/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Objects;
import java.util.Optional;

public final class PolicyRule {
    private final RuleType type;
    private final String method;
    private final Integer eventKind;
    private final Long maxUsage;
    private final long currentUsage;
    private final String description;

    private PolicyRule(RuleType type, String method, Integer eventKind, Long maxUsage, long currentUsage, String description) {
        this.type = Objects.requireNonNull(type, "Rule type cannot be null");
        this.method = method;
        this.eventKind = eventKind;
        this.maxUsage = maxUsage;
        this.currentUsage = currentUsage;
        this.description = description;
        if (method == null && eventKind == null) {
            throw new IllegalArgumentException("Rule must specify either method or eventKind");
        }
        if (method != null && eventKind != null) {
            throw new IllegalArgumentException("Rule cannot specify both method and eventKind");
        }
        if (maxUsage != null && maxUsage <= 0L) {
            throw new IllegalArgumentException("maxUsage must be positive if specified");
        }
        if (currentUsage < 0L) {
            throw new IllegalArgumentException("currentUsage cannot be negative");
        }
    }

    public static PolicyRule allowMethod(String method) {
        return new PolicyRule(RuleType.ALLOW, PolicyRule.validateMethod(method), null, null, 0L, null);
    }

    public static PolicyRule denyMethod(String method) {
        return new PolicyRule(RuleType.DENY, PolicyRule.validateMethod(method), null, null, 0L, null);
    }

    public static PolicyRule allowEventKind(int kind) {
        return new PolicyRule(RuleType.ALLOW, null, PolicyRule.validateKind(kind), null, 0L, null);
    }

    public static PolicyRule denyEventKind(int kind) {
        return new PolicyRule(RuleType.DENY, null, PolicyRule.validateKind(kind), null, 0L, null);
    }

    private static String validateMethod(String method) {
        Objects.requireNonNull(method, "Method cannot be null");
        String trimmed = method.trim().toLowerCase();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Method cannot be empty");
        }
        return trimmed;
    }

    private static Integer validateKind(int kind) {
        if (kind < 0) {
            throw new IllegalArgumentException("Event kind cannot be negative");
        }
        return kind;
    }

    public PolicyRule withMaxUsage(long limit) {
        return new PolicyRule(this.type, this.method, this.eventKind, limit, this.currentUsage, this.description);
    }

    public PolicyRule withDescription(String desc) {
        return new PolicyRule(this.type, this.method, this.eventKind, this.maxUsage, this.currentUsage, desc);
    }

    public PolicyRule incrementUsage() {
        if (this.isUsageLimitReached()) {
            throw new IllegalStateException("Usage limit reached");
        }
        return new PolicyRule(this.type, this.method, this.eventKind, this.maxUsage, this.currentUsage + 1L, this.description);
    }

    public boolean appliesTo(String methodName) {
        return this.method != null && this.method.equalsIgnoreCase(methodName);
    }

    public boolean appliesTo(int kind) {
        return this.eventKind != null && this.eventKind == kind;
    }

    public boolean isAllow() {
        return this.type == RuleType.ALLOW;
    }

    public boolean isDeny() {
        return this.type == RuleType.DENY;
    }

    public boolean hasUsageLimit() {
        return this.maxUsage != null;
    }

    public boolean isUsageLimitReached() {
        return this.maxUsage != null && this.currentUsage >= this.maxUsage;
    }

    public Optional<Long> getRemainingUsage() {
        if (this.maxUsage == null) {
            return Optional.empty();
        }
        return Optional.of(Math.max(0L, this.maxUsage - this.currentUsage));
    }

    public boolean isMethodRule() {
        return this.method != null;
    }

    public boolean isEventKindRule() {
        return this.eventKind != null;
    }

    public RuleType getType() {
        return this.type;
    }

    public Optional<String> getMethod() {
        return Optional.ofNullable(this.method);
    }

    public Optional<Integer> getEventKind() {
        return Optional.ofNullable(this.eventKind);
    }

    public Optional<Long> getMaxUsage() {
        return Optional.ofNullable(this.maxUsage);
    }

    public long getCurrentUsage() {
        return this.currentUsage;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyRule that = (PolicyRule)o;
        return this.currentUsage == that.currentUsage && this.type == that.type && Objects.equals(this.method, that.method) && Objects.equals(this.eventKind, that.eventKind) && Objects.equals(this.maxUsage, that.maxUsage) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.method, this.eventKind, this.maxUsage, this.currentUsage, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.name()).append("(");
        if (this.method != null) {
            sb.append("method=").append(this.method);
        } else {
            sb.append("kind=").append(this.eventKind);
        }
        if (this.maxUsage != null) {
            sb.append(", usage=").append(this.currentUsage).append("/").append(this.maxUsage);
        }
        if (this.description != null) {
            sb.append(", desc='").append(this.description).append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    public static enum RuleType {
        ALLOW,
        DENY;

    }
}

