/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Arrays;
import java.util.Objects;

public class PrivateKey {
    private static final int KEY_LENGTH = 32;
    private final byte[] keyBytes;

    public PrivateKey(byte[] keyBytes) {
        Objects.requireNonNull(keyBytes, "Private key bytes cannot be null");
        if (keyBytes.length != 32) {
            throw new IllegalArgumentException(String.format("Private key must be exactly %d bytes, got %d", 32, keyBytes.length));
        }
        this.keyBytes = Arrays.copyOf(keyBytes, keyBytes.length);
    }

    public static PrivateKey fromNostrJava(nostr.base.PrivateKey nostrPrivateKey) {
        Objects.requireNonNull(nostrPrivateKey, "Nostr-java PrivateKey cannot be null");
        return new PrivateKey(nostrPrivateKey.getRawData());
    }

    public nostr.base.PrivateKey toNostrJava() {
        return new nostr.base.PrivateKey(this.keyBytes);
    }

    public byte[] getRawBytes() {
        return Arrays.copyOf(this.keyBytes, this.keyBytes.length);
    }

    public byte[] rawData() {
        return this.getRawBytes();
    }

    public int length() {
        return this.keyBytes.length;
    }

    public static PrivateKey fromHex(String hex) {
        Objects.requireNonNull(hex, "Hex string cannot be null");
        if (hex.length() != 64) {
            throw new IllegalArgumentException(String.format("Hex string must be exactly %d characters, got %d", 64, hex.length()));
        }
        return new PrivateKey(PrivateKey.hexToBytes(hex));
    }

    public String toHex() {
        return PrivateKey.bytesToHex(this.keyBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivateKey that = (PrivateKey)o;
        return Arrays.equals(this.keyBytes, that.keyBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyBytes);
    }

    public String toString() {
        return "PrivateKey{length=" + this.keyBytes.length + ", hash=" + Integer.toHexString(this.hashCode()) + "}";
    }

    public void clear() {
        Arrays.fill(this.keyBytes, (byte)0);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            data[i2 / 2] = (byte)((Character.digit(hex.charAt(i2), 16) << 4) + Character.digit(hex.charAt(i2 + 1), 16));
        }
        return data;
    }
}

