/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import xyz.tcheeric.identity.domain.PolicyRule;

public class SigningPolicy {
    private final String id;
    private final String name;
    private final String description;
    private final List<PolicyRule> rules;
    private final Instant createdAt;
    private final Instant expiresAt;
    private final boolean active;

    public SigningPolicy(String name, String description) {
        this(UUID.randomUUID().toString(), name, description, new ArrayList<PolicyRule>(), Instant.now(), null, true);
    }

    public SigningPolicy(String id, String name, String description, List<PolicyRule> rules, Instant createdAt, Instant expiresAt, boolean active) {
        this.id = Objects.requireNonNull(id, "Policy ID cannot be null");
        this.name = SigningPolicy.validateName(name);
        this.description = description;
        this.rules = new ArrayList<PolicyRule>((Collection)Objects.requireNonNull(rules, "Rules list cannot be null"));
        this.createdAt = Objects.requireNonNull(createdAt, "Created timestamp cannot be null");
        this.expiresAt = expiresAt;
        this.active = active;
    }

    private static String validateName(String name) {
        Objects.requireNonNull(name, "Policy name cannot be null");
        String trimmed = name.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Policy name cannot be empty");
        }
        if (trimmed.length() > 100) {
            throw new IllegalArgumentException("Policy name cannot exceed 100 characters");
        }
        return trimmed;
    }

    public SigningPolicy addRule(PolicyRule rule) {
        Objects.requireNonNull(rule, "Rule cannot be null");
        ArrayList<PolicyRule> newRules = new ArrayList<PolicyRule>(this.rules);
        newRules.add(rule);
        return new SigningPolicy(this.id, this.name, this.description, newRules, this.createdAt, this.expiresAt, this.active);
    }

    public SigningPolicy withExpiresAt(Instant expiry) {
        return new SigningPolicy(this.id, this.name, this.description, this.rules, this.createdAt, expiry, this.active);
    }

    public SigningPolicy withExpiration(Duration duration) {
        return this.withExpiresAt(Instant.now().plus(duration));
    }

    public SigningPolicy withActive(boolean isActive) {
        return new SigningPolicy(this.id, this.name, this.description, this.rules, this.createdAt, this.expiresAt, isActive);
    }

    public boolean isMethodAllowed(String method) {
        if (!this.isValid()) {
            return false;
        }
        for (PolicyRule rule : this.rules) {
            if (!rule.appliesTo(method)) continue;
            return rule.isAllow() && !rule.isUsageLimitReached();
        }
        return false;
    }

    public boolean isEventKindAllowed(int kind) {
        if (!this.isValid()) {
            return false;
        }
        for (PolicyRule rule : this.rules) {
            if (!rule.appliesTo(kind)) continue;
            return rule.isAllow() && !rule.isUsageLimitReached();
        }
        return false;
    }

    public boolean isValid() {
        return this.active && !this.isExpired();
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().isAfter(this.expiresAt);
    }

    public Optional<Duration> getTimeUntilExpiration() {
        if (this.expiresAt == null) {
            return Optional.empty();
        }
        Duration remaining = Duration.between(Instant.now(), this.expiresAt);
        return Optional.of(remaining.isNegative() ? Duration.ZERO : remaining);
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public List<PolicyRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Optional<Instant> getExpiresAt() {
        return Optional.ofNullable(this.expiresAt);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SigningPolicy that = (SigningPolicy)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "SigningPolicy{id='" + this.id + "', name='" + this.name + "', rules=" + this.rules.size() + ", active=" + this.active + ", expired=" + this.isExpired() + ", expiresAt=" + String.valueOf(this.expiresAt) + "}";
    }
}

