/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Arrays;
import java.util.List;

public final class Tag {
    private final String[] values;

    private Tag(String ... values2) {
        if (values2 == null || values2.length == 0) {
            throw new IllegalArgumentException("Tag must have at least one value");
        }
        this.values = Arrays.copyOf(values2, values2.length);
    }

    public static Tag of(String ... values2) {
        return new Tag(values2);
    }

    public static Tag of(List<String> values2) {
        if (values2 == null || values2.isEmpty()) {
            throw new IllegalArgumentException("Tag must have at least one value");
        }
        return new Tag(values2.toArray(new String[0]));
    }

    public String type() {
        return this.values[0];
    }

    public String[] values() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public List<String> toList() {
        return List.of(this.values);
    }

    public int size() {
        return this.values.length;
    }

    public String get(int index) {
        return this.values[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Arrays.equals(this.values, tag.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return "Tag" + Arrays.toString(this.values);
    }
}

