/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.crypto;

import java.security.SecureRandom;
import nostr.base.PrivateKey;
import nostr.base.PublicKey;
import nostr.crypto.nip44.EncryptedPayloads;

public class Nip44Encryptor {
    private static final int NONCE_SIZE = 32;

    public static String encrypt(PrivateKey privateKey, PublicKey recipientPubKey, String plaintext) throws Exception {
        byte[] conversationKey = EncryptedPayloads.getConversationKey(Nip44Encryptor.bytesToHex(privateKey.getRawData()), Nip44Encryptor.bytesToHex(recipientPubKey.getRawData()));
        byte[] nonce = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(nonce);
        return EncryptedPayloads.encrypt(plaintext, conversationKey, nonce);
    }

    public static String decrypt(PrivateKey privateKey, PublicKey senderPubKey, String ciphertext) throws Exception {
        byte[] conversationKey = EncryptedPayloads.getConversationKey(Nip44Encryptor.bytesToHex(privateKey.getRawData()), Nip44Encryptor.bytesToHex(senderPubKey.getRawData()));
        return EncryptedPayloads.decrypt(ciphertext, conversationKey);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void validateParameters(PrivateKey privateKey, PublicKey publicKey, String data) {
        if (privateKey == null) {
            throw new IllegalArgumentException("Private key cannot be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key cannot be null");
        }
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
    }
}

