/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.crypto;

import java.util.List;
import java.util.stream.Collectors;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;
import xyz.tcheeric.identity.domain.NostrEvent;
import xyz.tcheeric.identity.domain.PrivateKey;
import xyz.tcheeric.identity.infrastructure.crypto.KeyGenerator;
import xyz.tcheeric.identity.infrastructure.crypto.Nip44Encryptor;

public final class NostrJavaCryptoAdapter {
    private NostrJavaCryptoAdapter() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static PrivateKey generatePrivateKey() {
        nostr.base.PrivateKey nostrPrivateKey = KeyGenerator.generatePrivateKey();
        return PrivateKey.fromNostrJava(nostrPrivateKey);
    }

    public static xyz.tcheeric.identity.domain.PublicKey derivePublicKey(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        nostr.base.PrivateKey nostrPrivateKey = privateKey.toNostrJava();
        PublicKey nostrPublicKey = KeyGenerator.derivePublicKey(nostrPrivateKey);
        return xyz.tcheeric.identity.domain.PublicKey.fromNostrJava(nostrPublicKey);
    }

    public static KeyPair generateKeyPair() {
        PrivateKey privateKey = NostrJavaCryptoAdapter.generatePrivateKey();
        xyz.tcheeric.identity.domain.PublicKey publicKey = NostrJavaCryptoAdapter.derivePublicKey(privateKey);
        return new KeyPair(privateKey, publicKey);
    }

    public static nostr.base.PrivateKey toNostrJavaPrivateKey(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        return privateKey.toNostrJava();
    }

    public static PublicKey toNostrJavaPublicKey(xyz.tcheeric.identity.domain.PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey cannot be null");
        }
        return publicKey.toNostrJava();
    }

    public static PrivateKey toDomainPrivateKey(nostr.base.PrivateKey nostrPrivateKey) {
        if (nostrPrivateKey == null) {
            throw new IllegalArgumentException("nostrPrivateKey cannot be null");
        }
        return PrivateKey.fromNostrJava(nostrPrivateKey);
    }

    public static xyz.tcheeric.identity.domain.PublicKey toDomainPublicKey(PublicKey nostrPublicKey) {
        if (nostrPublicKey == null) {
            throw new IllegalArgumentException("nostrPublicKey cannot be null");
        }
        return xyz.tcheeric.identity.domain.PublicKey.fromNostrJava(nostrPublicKey);
    }

    public static SignedEventData signEvent(PrivateKey privateKey, NostrEvent event) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (event.isSigned()) {
            throw new IllegalArgumentException("Event is already signed");
        }
        nostr.base.PrivateKey nostrPrivateKey = privateKey.toNostrJava();
        PublicKey nostrPublicKey = new PublicKey(NostrJavaCryptoAdapter.hexToBytes(event.pubkey()));
        List<BaseTag> nostrTags = event.tags().stream().map(tag -> {
            String[] values2 = tag.values();
            if (values2.length == 1) {
                return BaseTag.create(values2[0], new String[0]);
            }
            String code = values2[0];
            String[] rest = new String[values2.length - 1];
            System.arraycopy(values2, 1, rest, 0, rest.length);
            return BaseTag.create(code, rest);
        }).collect(Collectors.toList());
        GenericEvent genericEvent = new GenericEvent(nostrPublicKey, event.kind(), nostrTags, event.content());
        if (event.createdAt() != null) {
            genericEvent.setCreatedAt(event.createdAt());
        } else {
            genericEvent.setCreatedAt(System.currentTimeMillis() / 1000L);
        }
        genericEvent.update();
        Identity identity = Identity.create(nostrPrivateKey);
        Signature signature = identity.sign(genericEvent);
        return new SignedEventData(genericEvent.getId(), signature.toString());
    }

    public static String encrypt(PrivateKey senderPrivateKey, xyz.tcheeric.identity.domain.PublicKey recipientPublicKey, String plaintext) throws Exception {
        if (senderPrivateKey == null) {
            throw new IllegalArgumentException("senderPrivateKey cannot be null");
        }
        if (recipientPublicKey == null) {
            throw new IllegalArgumentException("recipientPublicKey cannot be null");
        }
        if (plaintext == null) {
            throw new IllegalArgumentException("plaintext cannot be null");
        }
        nostr.base.PrivateKey nostrPrivateKey = senderPrivateKey.toNostrJava();
        PublicKey nostrPublicKey = recipientPublicKey.toNostrJava();
        return Nip44Encryptor.encrypt(nostrPrivateKey, nostrPublicKey, plaintext);
    }

    public static String decrypt(PrivateKey recipientPrivateKey, xyz.tcheeric.identity.domain.PublicKey senderPublicKey, String ciphertext) throws Exception {
        if (recipientPrivateKey == null) {
            throw new IllegalArgumentException("recipientPrivateKey cannot be null");
        }
        if (senderPublicKey == null) {
            throw new IllegalArgumentException("senderPublicKey cannot be null");
        }
        if (ciphertext == null || ciphertext.isEmpty()) {
            throw new IllegalArgumentException("ciphertext cannot be null or empty");
        }
        nostr.base.PrivateKey nostrPrivateKey = recipientPrivateKey.toNostrJava();
        PublicKey nostrPublicKey = senderPublicKey.toNostrJava();
        return Nip44Encryptor.decrypt(nostrPrivateKey, nostrPublicKey, ciphertext);
    }

    private static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            data[i2 / 2] = (byte)((Character.digit(hex.charAt(i2), 16) << 4) + Character.digit(hex.charAt(i2 + 1), 16));
        }
        return data;
    }

    public record KeyPair(PrivateKey privateKey, xyz.tcheeric.identity.domain.PublicKey publicKey) {
        public KeyPair {
            if (privateKey == null) {
                throw new IllegalArgumentException("privateKey cannot be null");
            }
            if (publicKey == null) {
                throw new IllegalArgumentException("publicKey cannot be null");
            }
        }
    }

    public record SignedEventData(String eventId, String signature) {
        public SignedEventData {
            if (eventId == null || eventId.isEmpty()) {
                throw new IllegalArgumentException("eventId cannot be null or empty");
            }
            if (signature == null || signature.isEmpty()) {
                throw new IllegalArgumentException("signature cannot be null or empty");
            }
        }
    }
}

