/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.messaging;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xyz.tcheeric.identity.api.ports.AuthenticationPort;
import xyz.tcheeric.identity.application.usecases.RegisterPluginUseCase;
import xyz.tcheeric.identity.infrastructure.messaging.InProcessMessageBus;
import xyz.tcheeric.identity.infrastructure.messaging.handlers.DecryptMessageHandler;
import xyz.tcheeric.identity.infrastructure.messaging.handlers.EncryptMessageHandler;
import xyz.tcheeric.identity.infrastructure.messaging.handlers.PluginRegistrationHandler;
import xyz.tcheeric.identity.infrastructure.messaging.handlers.SignEventHandler;

public final class IdentityMessagingBootstrap {
    private IdentityMessagingBootstrap() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static InProcessMessageBus create(AuthenticationPort authenticationPort, RegisterPluginUseCase registerPluginUseCase) {
        return IdentityMessagingBootstrap.create(authenticationPort, registerPluginUseCase, Executors.newCachedThreadPool());
    }

    public static InProcessMessageBus create(AuthenticationPort authenticationPort, RegisterPluginUseCase registerPluginUseCase, ExecutorService executorService) {
        if (authenticationPort == null) {
            throw new IllegalArgumentException("authenticationPort cannot be null");
        }
        if (registerPluginUseCase == null) {
            throw new IllegalArgumentException("registerPluginUseCase cannot be null");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("executorService cannot be null");
        }
        InProcessMessageBus messageBus = new InProcessMessageBus(executorService);
        IdentityMessagingBootstrap.registerHandlers(messageBus, authenticationPort, registerPluginUseCase);
        return messageBus;
    }

    static void registerHandlers(InProcessMessageBus messageBus, AuthenticationPort authenticationPort, RegisterPluginUseCase registerPluginUseCase) {
        PluginRegistrationHandler registrationHandler = new PluginRegistrationHandler(registerPluginUseCase);
        messageBus.subscribe(registrationHandler);
        SignEventHandler signEventHandler = new SignEventHandler(authenticationPort);
        messageBus.subscribe(signEventHandler);
        EncryptMessageHandler encryptHandler = new EncryptMessageHandler(authenticationPort);
        messageBus.subscribe(encryptHandler);
        DecryptMessageHandler decryptHandler = new DecryptMessageHandler(authenticationPort);
        messageBus.subscribe(decryptHandler);
    }
}

