/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.messaging;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.messaging.contracts.IdentityMessage;
import xyz.tcheeric.messaging.contracts.MessageClient;
import xyz.tcheeric.messaging.contracts.MessageHandler;
import xyz.tcheeric.messaging.contracts.MessageServer;

public class InProcessMessageBus
implements MessageClient,
MessageServer {
    private static final Logger log = LoggerFactory.getLogger(InProcessMessageBus.class);
    private final ConcurrentMap<Class<? extends IdentityMessage>, MessageHandler<?, ?>> handlers = new ConcurrentHashMap();
    private final ExecutorService executorService;

    public InProcessMessageBus() {
        this(Executors.newCachedThreadPool());
    }

    public InProcessMessageBus(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public <T extends IdentityMessage> T sendSync(IdentityMessage message, Class<T> responseType) {
        if (message == null) {
            throw new MessageClient.MessageSendException("message cannot be null", null);
        }
        if (responseType == null) {
            throw new MessageClient.MessageSendException("responseType cannot be null", null);
        }
        Class<?> messageType = message.getClass();
        String messageInfo = message.toString();
        log.debug("message_bus_request message_type={} message={} expected_response_type={}", messageType.getSimpleName(), messageInfo, responseType.getSimpleName());
        MessageHandler handler = (MessageHandler)this.handlers.get(messageType);
        if (handler == null) {
            log.error("message_bus_no_handler message_type={} message={} error=no_handler_registered", (Object)messageType.getSimpleName(), (Object)messageInfo);
            throw new MessageClient.MessageSendException("No handler registered for message type: " + messageType.getSimpleName(), null);
        }
        long startTime = System.nanoTime();
        try {
            MessageHandler typedHandler = handler;
            log.debug("message_bus_invoking_handler message_type={} handler={}", (Object)messageType.getSimpleName(), (Object)handler.getClass().getSimpleName());
            Object response = typedHandler.handle(message);
            long durationMs = (System.nanoTime() - startTime) / 1000000L;
            if (response == null) {
                log.error("message_bus_null_response message_type={} duration_ms={} error=handler_returned_null", (Object)messageType.getSimpleName(), (Object)durationMs);
                throw new MessageClient.MessageHandlerException("Handler returned null response for message type: " + messageType.getSimpleName(), null);
            }
            if (!responseType.isInstance(response)) {
                log.error("message_bus_wrong_response_type message_type={} duration_ms={} expected={} actual={} error=type_mismatch", messageType.getSimpleName(), durationMs, responseType.getSimpleName(), response.getClass().getSimpleName());
                throw new MessageClient.MessageHandlerException("Handler returned wrong response type. Expected: " + responseType.getSimpleName() + ", got: " + response.getClass().getSimpleName(), null);
            }
            log.info("message_bus_success message_type={} response_type={} duration_ms={} response={}", messageType.getSimpleName(), response.getClass().getSimpleName(), durationMs, response.toString());
            return (T)((IdentityMessage)responseType.cast(response));
        }
        catch (MessageClient.MessageHandlerException e) {
            long durationMs = (System.nanoTime() - startTime) / 1000000L;
            log.error("message_bus_handler_error message_type={} duration_ms={} error={}", messageType.getSimpleName(), durationMs, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            long durationMs = (System.nanoTime() - startTime) / 1000000L;
            log.error("message_bus_unexpected_error message_type={} duration_ms={} error={}", messageType.getSimpleName(), durationMs, e.getMessage(), e);
            throw new MessageClient.MessageHandlerException("Handler threw exception for message type: " + messageType.getSimpleName(), e);
        }
    }

    @Override
    public <T extends IdentityMessage> CompletableFuture<T> sendAsync(IdentityMessage message, Class<T> responseType) {
        return CompletableFuture.supplyAsync(() -> this.sendSync(message, responseType), this.executorService);
    }

    @Override
    public <REQ extends IdentityMessage, RES extends IdentityMessage> void subscribe(MessageHandler<REQ, RES> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Class<REQ> requestType = handler.getRequestType();
        if (requestType == null) {
            throw new IllegalArgumentException("handler.getRequestType() returned null. Ensure handler implements getRequestType() correctly.");
        }
        MessageHandler<REQ, RES> existing = this.handlers.putIfAbsent(requestType, handler);
        if (existing != null) {
            log.error("message_bus_handler_already_registered message_type={} handler={} existing_handler={}", requestType.getSimpleName(), handler.getClass().getSimpleName(), existing.getClass().getSimpleName());
            throw new MessageServer.HandlerAlreadyRegisteredException(requestType);
        }
        log.info("message_bus_handler_registered message_type={} handler={} total_handlers={}", requestType.getSimpleName(), handler.getClass().getSimpleName(), this.handlers.size());
    }

    @Override
    public <REQ extends IdentityMessage, RES extends IdentityMessage> void unsubscribe(MessageHandler<REQ, RES> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Class<REQ> requestType = handler.getRequestType();
        if (requestType == null) {
            return;
        }
        boolean removed = this.handlers.remove(requestType, handler);
        if (removed) {
            log.info("message_bus_handler_unregistered message_type={} handler={} total_handlers={}", requestType.getSimpleName(), handler.getClass().getSimpleName(), this.handlers.size());
        } else {
            log.debug("message_bus_handler_not_found message_type={} handler={}", (Object)requestType.getSimpleName(), (Object)handler.getClass().getSimpleName());
        }
    }

    public int getHandlerCount() {
        return this.handlers.size();
    }

    public boolean hasHandlerFor(Class<? extends IdentityMessage> messageType) {
        return this.handlers.containsKey(messageType);
    }

    public void clear() {
        this.handlers.clear();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void shutdownNow() {
        this.executorService.shutdownNow();
    }
}

