/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.messaging.handlers;

import xyz.tcheeric.identity.api.ports.AuthenticationPort;
import xyz.tcheeric.messaging.contracts.MessageHandler;
import xyz.tcheeric.messaging.messages.DecryptMessageRequest;
import xyz.tcheeric.messaging.messages.DecryptMessageResponse;

public class DecryptMessageHandler
implements MessageHandler<DecryptMessageRequest, DecryptMessageResponse> {
    private final AuthenticationPort authenticationPort;

    public DecryptMessageHandler(AuthenticationPort authenticationPort) {
        if (authenticationPort == null) {
            throw new IllegalArgumentException("authenticationPort cannot be null");
        }
        this.authenticationPort = authenticationPort;
    }

    @Override
    public DecryptMessageResponse handle(DecryptMessageRequest request) {
        String authToken = request.authToken();
        if (!this.authenticationPort.validateToken(authToken)) {
            return DecryptMessageResponse.failure(request.requestId(), "Invalid authentication token");
        }
        String pluginName = this.authenticationPort.getSubject(authToken).orElse("unknown");
        return DecryptMessageResponse.failure(request.requestId(), "Message decryption not yet fully implemented - infrastructure in place");
    }

    @Override
    public Class<DecryptMessageRequest> getRequestType() {
        return DecryptMessageRequest.class;
    }
}

