/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.messaging.handlers;

import xyz.tcheeric.identity.api.ports.AuthenticationPort;
import xyz.tcheeric.messaging.contracts.MessageHandler;
import xyz.tcheeric.messaging.messages.EncryptMessageRequest;
import xyz.tcheeric.messaging.messages.EncryptMessageResponse;

public class EncryptMessageHandler
implements MessageHandler<EncryptMessageRequest, EncryptMessageResponse> {
    private final AuthenticationPort authenticationPort;

    public EncryptMessageHandler(AuthenticationPort authenticationPort) {
        if (authenticationPort == null) {
            throw new IllegalArgumentException("authenticationPort cannot be null");
        }
        this.authenticationPort = authenticationPort;
    }

    @Override
    public EncryptMessageResponse handle(EncryptMessageRequest request) {
        String authToken = request.authToken();
        if (!this.authenticationPort.validateToken(authToken)) {
            return EncryptMessageResponse.failure(request.requestId(), "Invalid authentication token");
        }
        String pluginName = this.authenticationPort.getSubject(authToken).orElse("unknown");
        return EncryptMessageResponse.failure(request.requestId(), "Message encryption not yet fully implemented - infrastructure in place");
    }

    @Override
    public Class<EncryptMessageRequest> getRequestType() {
        return EncryptMessageRequest.class;
    }
}

