/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.messaging.handlers;

import xyz.tcheeric.identity.application.usecases.RegisterPluginUseCase;
import xyz.tcheeric.messaging.contracts.MessageHandler;
import xyz.tcheeric.messaging.messages.PluginRegistrationRequest;
import xyz.tcheeric.messaging.messages.PluginRegistrationResponse;

public class PluginRegistrationHandler
implements MessageHandler<PluginRegistrationRequest, PluginRegistrationResponse> {
    private final RegisterPluginUseCase registerPluginUseCase;

    public PluginRegistrationHandler(RegisterPluginUseCase registerPluginUseCase) {
        if (registerPluginUseCase == null) {
            throw new IllegalArgumentException("registerPluginUseCase cannot be null");
        }
        this.registerPluginUseCase = registerPluginUseCase;
    }

    @Override
    public PluginRegistrationResponse handle(PluginRegistrationRequest request) {
        String pluginVersion;
        String pluginName = request.pluginName();
        RegisterPluginUseCase.RegisterPluginResult result = this.registerPluginUseCase.execute(pluginName, pluginVersion = request.pluginVersion());
        if (result.success()) {
            return PluginRegistrationResponse.success(request.requestId(), result.authToken());
        }
        return PluginRegistrationResponse.failure(request.requestId(), result.errorMessage());
    }

    @Override
    public Class<PluginRegistrationRequest> getRequestType() {
        return PluginRegistrationRequest.class;
    }
}

