/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.messaging.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.AuthenticationPort;
import xyz.tcheeric.messaging.contracts.MessageHandler;
import xyz.tcheeric.messaging.messages.SignEventRequest;
import xyz.tcheeric.messaging.messages.SignEventResponse;

public class SignEventHandler
implements MessageHandler<SignEventRequest, SignEventResponse> {
    private static final Logger log = LoggerFactory.getLogger(SignEventHandler.class);
    private final AuthenticationPort authenticationPort;

    public SignEventHandler(AuthenticationPort authenticationPort) {
        if (authenticationPort == null) {
            throw new IllegalArgumentException("authenticationPort cannot be null");
        }
        this.authenticationPort = authenticationPort;
    }

    @Override
    public SignEventResponse handle(SignEventRequest request) {
        log.debug("sign_event_handler_request request_id={} kind={} content_length={} tags_count={}", request.requestId(), request.kind(), request.content().length(), request.tags().size());
        String authToken = request.authToken();
        if (!this.authenticationPort.validateToken(authToken)) {
            log.warn("sign_event_handler_auth_failed request_id={} error=invalid_token", (Object)request.requestId());
            return SignEventResponse.failure(request.requestId(), "Invalid authentication token");
        }
        String pluginName = this.authenticationPort.getSubject(authToken).orElse("unknown");
        log.debug("sign_event_handler_authenticated request_id={} plugin_name={}", (Object)request.requestId(), (Object)pluginName);
        log.warn("sign_event_handler_not_implemented request_id={} plugin_name={} kind={} error=not_yet_implemented", request.requestId(), pluginName, request.kind());
        return SignEventResponse.failure(request.requestId(), "Event signing not yet fully implemented - infrastructure in place");
    }

    @Override
    public Class<SignEventRequest> getRequestType() {
        return SignEventRequest.class;
    }
}

