/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.nostr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.StandardWebSocketClient;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseTag;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.Filterable;
import nostr.event.filter.Filters;
import nostr.event.filter.KindFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.message.EventMessage;
import nostr.event.message.ReqMessage;
import nostr.event.tag.GenericTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.api.ports.SigningPort;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.MerchantProfile;
import xyz.tcheeric.identity.domain.NostrEvent;
import xyz.tcheeric.identity.domain.PaymentMethod;
import xyz.tcheeric.identity.domain.ProfileMetadata;
import xyz.tcheeric.identity.domain.Tag;

public class NostrProfileAdapter
implements ProfilePort,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NostrProfileAdapter.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final int KIND_METADATA = 0;
    private static final int KIND_APP_SPECIFIC = 30078;
    private static final int KIND_DELETION = 5;
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(30L);
    private final List<String> relayUrls;
    private final SigningPort signingPort;
    private final Supplier<Optional<BunkerIdentity>> identityResolver;
    private final Duration requestTimeout;
    private final ConcurrentHashMap<String, ClientContext> clientCache;

    public NostrProfileAdapter(List<String> relayUrls, SigningPort signingPort, Supplier<Optional<BunkerIdentity>> identityResolver) {
        this(relayUrls, signingPort, identityResolver, DEFAULT_REQUEST_TIMEOUT);
    }

    public NostrProfileAdapter(List<String> relayUrls, SigningPort signingPort, Supplier<Optional<BunkerIdentity>> identityResolver, Duration requestTimeout) {
        this.relayUrls = List.copyOf((Collection)Objects.requireNonNull(relayUrls, "Relay URLs cannot be null"));
        this.signingPort = Objects.requireNonNull(signingPort, "Signing port cannot be null");
        this.identityResolver = Objects.requireNonNull(identityResolver, "Identity resolver cannot be null");
        this.requestTimeout = Objects.requireNonNull(requestTimeout, "Request timeout cannot be null");
        this.clientCache = new ConcurrentHashMap();
        if (relayUrls.isEmpty()) {
            throw new IllegalArgumentException("At least one relay URL is required");
        }
        LOGGER.info("nostr_profile_adapter_created relays={}", (Object)relayUrls.size());
    }

    @Override
    public CompletableFuture<Optional<ProfileMetadata>> getProfile(String pubkey) {
        Objects.requireNonNull(pubkey, "Public key cannot be null");
        this.validateHexPubkey(pubkey);
        LOGGER.debug("get_profile_started pubkey={}", (Object)this.truncatePubkey(pubkey));
        return ((CompletableFuture)this.fetchLatestEvent(pubkey, 0, null).thenApply(eventOpt -> eventOpt.map(this::parseProfileMetadata))).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.error("get_profile_failed pubkey={} error={}", (Object)this.truncatePubkey(pubkey), (Object)error.getMessage());
            } else {
                LOGGER.debug("get_profile_complete pubkey={} found={}", (Object)this.truncatePubkey(pubkey), (Object)result.isPresent());
            }
        });
    }

    @Override
    public CompletableFuture<Void> updateProfile(String pubkey, ProfileMetadata metadata) {
        Objects.requireNonNull(pubkey, "Public key cannot be null");
        Objects.requireNonNull(metadata, "Metadata cannot be null");
        this.validateHexPubkey(pubkey);
        LOGGER.info("update_profile_started pubkey={}", (Object)this.truncatePubkey(pubkey));
        String content = this.serializeProfileMetadata(metadata);
        NostrEvent unsignedEvent = NostrEvent.createUnsigned(0, content, pubkey, List.of());
        return this.signAndPublish(pubkey, unsignedEvent).whenComplete((v, error) -> {
            if (error != null) {
                LOGGER.error("update_profile_failed pubkey={} error={}", (Object)this.truncatePubkey(pubkey), (Object)error.getMessage());
            } else {
                LOGGER.info("update_profile_complete pubkey={}", (Object)this.truncatePubkey(pubkey));
            }
        });
    }

    @Override
    public CompletableFuture<Optional<MerchantProfile>> getMerchantProfile(String pubkey) {
        Objects.requireNonNull(pubkey, "Public key cannot be null");
        this.validateHexPubkey(pubkey);
        LOGGER.debug("get_merchant_profile_started pubkey={}", (Object)this.truncatePubkey(pubkey));
        return ((CompletableFuture)this.fetchLatestEvent(pubkey, 30078, "imani:merchant").thenApply(eventOpt -> eventOpt.map(this::parseMerchantProfile))).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.error("get_merchant_profile_failed pubkey={} error={}", (Object)this.truncatePubkey(pubkey), (Object)error.getMessage());
            } else {
                LOGGER.debug("get_merchant_profile_complete pubkey={} found={}", (Object)this.truncatePubkey(pubkey), (Object)result.isPresent());
            }
        });
    }

    @Override
    public CompletableFuture<Void> setMerchantProfile(String pubkey, MerchantProfile profile2) {
        Objects.requireNonNull(pubkey, "Public key cannot be null");
        Objects.requireNonNull(profile2, "Profile cannot be null");
        this.validateHexPubkey(pubkey);
        LOGGER.info("set_merchant_profile_started pubkey={} active={}", (Object)this.truncatePubkey(pubkey), (Object)profile2.active());
        String content = this.serializeMerchantProfile(profile2);
        List<Tag> tags = List.of(Tag.of("d", "imani:merchant"));
        NostrEvent unsignedEvent = NostrEvent.createUnsigned(30078, content, pubkey, tags);
        return this.signAndPublish(pubkey, unsignedEvent).whenComplete((v, error) -> {
            if (error != null) {
                LOGGER.error("set_merchant_profile_failed pubkey={} error={}", (Object)this.truncatePubkey(pubkey), (Object)error.getMessage());
            } else {
                LOGGER.info("set_merchant_profile_complete pubkey={}", (Object)this.truncatePubkey(pubkey));
            }
        });
    }

    @Override
    public CompletableFuture<Void> disableMerchant(String pubkey) {
        Objects.requireNonNull(pubkey, "Public key cannot be null");
        this.validateHexPubkey(pubkey);
        LOGGER.info("disable_merchant_started pubkey={}", (Object)this.truncatePubkey(pubkey));
        return ((CompletableFuture)this.getMerchantProfile(pubkey).thenCompose(profileOpt -> {
            if (profileOpt.isEmpty()) {
                LOGGER.debug("disable_merchant_skipped pubkey={} reason=no_profile", (Object)this.truncatePubkey(pubkey));
                return CompletableFuture.completedFuture(null);
            }
            MerchantProfile disabledProfile = ((MerchantProfile)profileOpt.get()).withActive(false);
            return this.setMerchantProfile(pubkey, disabledProfile);
        })).whenComplete((v, error) -> {
            if (error != null) {
                LOGGER.error("disable_merchant_failed pubkey={} error={}", (Object)this.truncatePubkey(pubkey), (Object)error.getMessage());
            } else {
                LOGGER.info("disable_merchant_complete pubkey={}", (Object)this.truncatePubkey(pubkey));
            }
        });
    }

    @Override
    public CompletableFuture<Void> deleteMerchantProfile(String pubkey) {
        Objects.requireNonNull(pubkey, "Public key cannot be null");
        this.validateHexPubkey(pubkey);
        LOGGER.info("delete_merchant_profile_started pubkey={}", (Object)this.truncatePubkey(pubkey));
        return ((CompletableFuture)this.fetchLatestEvent(pubkey, 30078, "imani:merchant").thenCompose(eventOpt -> {
            if (eventOpt.isEmpty()) {
                LOGGER.debug("delete_merchant_profile_skipped pubkey={} reason=no_profile", (Object)this.truncatePubkey(pubkey));
                return CompletableFuture.completedFuture(null);
            }
            GenericEvent event = (GenericEvent)eventOpt.get();
            String eventId = event.getId();
            List<Tag> tags = List.of(Tag.of("e", eventId), Tag.of("a", "30078:" + pubkey + ":imani:merchant"));
            NostrEvent deleteEvent = NostrEvent.createUnsigned(5, "delete merchant profile", pubkey, tags);
            return this.signAndPublish(pubkey, deleteEvent);
        })).whenComplete((v, error) -> {
            if (error != null) {
                LOGGER.error("delete_merchant_profile_failed pubkey={} error={}", (Object)this.truncatePubkey(pubkey), (Object)error.getMessage());
            } else {
                LOGGER.info("delete_merchant_profile_complete pubkey={}", (Object)this.truncatePubkey(pubkey));
            }
        });
    }

    private CompletableFuture<Optional<GenericEvent>> fetchLatestEvent(String pubkey, int kind, String dTag) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicReference latestEvent = new AtomicReference();
            CountDownLatch eoseLatch = new CountDownLatch(1);
            for (String relayUrl : this.relayUrls) {
                try {
                    SpringWebSocketClient client = this.getOrCreateClient(relayUrl);
                    String subscriptionId = "profile-" + UUID.randomUUID().toString().substring(0, 8);
                    ArrayList<Filterable> filterList = new ArrayList<Filterable>();
                    filterList.add(new AuthorFilter<PublicKey>(new PublicKey(pubkey)));
                    filterList.add(new KindFilter<Kind>(Kind.valueOf(kind)));
                    Filters filters = new Filters(filterList);
                    filters.setLimit(1);
                    ReqMessage reqMessage = new ReqMessage(subscriptionId, List.of(filters));
                    client.subscribe(reqMessage, jsonMessage -> {
                        if (jsonMessage.contains("\"EVENT\"")) {
                            GenericEvent current;
                            GenericEvent event = this.parseEventFromJson((String)jsonMessage);
                            if (!(event == null || dTag != null && !this.hasMatchingDTag(event, dTag) || (current = (GenericEvent)latestEvent.get()) != null && event.getCreatedAt() <= current.getCreatedAt())) {
                                latestEvent.set(event);
                            }
                        } else if (jsonMessage.contains("\"EOSE\"")) {
                            eoseLatch.countDown();
                        }
                    }, error -> LOGGER.warn("fetch_event_error relay={} error={}", (Object)relayUrl, (Object)error.getMessage()), () -> LOGGER.debug("fetch_event_subscription_closed relay={}", (Object)relayUrl));
                    if (!eoseLatch.await(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                        LOGGER.debug("fetch_event_timeout relay={}", (Object)relayUrl);
                    }
                    if (latestEvent.get() == null) continue;
                    break;
                }
                catch (Exception e) {
                    LOGGER.warn("fetch_event_relay_error relay={} error={}", (Object)relayUrl, (Object)e.getMessage());
                }
            }
            return Optional.ofNullable((GenericEvent)latestEvent.get());
        });
    }

    private CompletableFuture<Void> signAndPublish(String pubkey, NostrEvent unsignedEvent) {
        return this.identityResolver.get().map(identity -> this.signingPort.signEvent((BunkerIdentity)identity, unsignedEvent).thenCompose(result -> {
            NostrEvent signedEvent = unsignedEvent.withSignature(result.eventId(), result.signature());
            return this.publishToRelays(signedEvent);
        })).orElseGet(() -> CompletableFuture.failedFuture(new IdentityException("No identity found for pubkey: " + this.truncatePubkey(pubkey))));
    }

    private CompletableFuture<Void> publishToRelays(NostrEvent event) {
        return CompletableFuture.runAsync(() -> {
            GenericEvent genericEvent = this.toGenericEvent(event);
            EventMessage eventMessage = new EventMessage(genericEvent);
            int successCount = 0;
            for (String relayUrl : this.relayUrls) {
                try {
                    SpringWebSocketClient client = this.getOrCreateClient(relayUrl);
                    client.send(eventMessage);
                    ++successCount;
                    LOGGER.debug("publish_success relay={} event_id={}", (Object)relayUrl, (Object)event.id());
                }
                catch (Exception e) {
                    LOGGER.warn("publish_error relay={} event_id={} error={}", relayUrl, event.id(), e.getMessage());
                }
            }
            if (successCount == 0) {
                throw new RuntimeException("Failed to publish to any relay");
            }
            LOGGER.debug("publish_complete event_id={} relays={}", (Object)event.id(), (Object)successCount);
        });
    }

    private SpringWebSocketClient getOrCreateClient(String relayUrl) {
        ClientContext context = this.clientCache.computeIfAbsent(relayUrl, url -> {
            LOGGER.debug("creating_client relay={}", url);
            try {
                long awaitTimeoutMs = 60000L;
                long pollIntervalMs = 500L;
                StandardWebSocketClient webSocketClient = new StandardWebSocketClient((String)url, awaitTimeoutMs, pollIntervalMs);
                SpringWebSocketClient client = new SpringWebSocketClient(webSocketClient, (String)url);
                return new ClientContext(webSocketClient, client);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create WebSocket client for relay: " + url, e);
            }
        });
        return context.client();
    }

    private ProfileMetadata parseProfileMetadata(GenericEvent event) {
        try {
            JsonNode root = JSON_MAPPER.readTree(event.getContent());
            return ProfileMetadata.builder().name(this.getTextOrNull(root, "name")).about(this.getTextOrNull(root, "about")).picture(this.getTextOrNull(root, "picture")).nip05(this.getTextOrNull(root, "nip05")).lud16(this.getTextOrNull(root, "lud16")).banner(this.getTextOrNull(root, "banner")).website(this.getTextOrNull(root, "website")).build();
        }
        catch (Exception e) {
            LOGGER.warn("parse_profile_metadata_failed error={}", (Object)e.getMessage());
            return ProfileMetadata.empty();
        }
    }

    private String serializeProfileMetadata(ProfileMetadata metadata) {
        try {
            ObjectNode node = JSON_MAPPER.createObjectNode();
            metadata.getName().ifPresent(v -> node.put("name", (String)v));
            metadata.getAbout().ifPresent(v -> node.put("about", (String)v));
            metadata.getPicture().ifPresent(v -> node.put("picture", (String)v));
            metadata.getNip05().ifPresent(v -> node.put("nip05", (String)v));
            metadata.getLud16().ifPresent(v -> node.put("lud16", (String)v));
            metadata.getBanner().ifPresent(v -> node.put("banner", (String)v));
            metadata.getWebsite().ifPresent(v -> node.put("website", (String)v));
            return JSON_MAPPER.writeValueAsString(node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize profile metadata", e);
        }
    }

    private MerchantProfile parseMerchantProfile(GenericEvent event) {
        try {
            JsonNode root = JSON_MAPPER.readTree(event.getContent());
            boolean active = root.has("active") && root.get("active").asBoolean(false);
            ArrayList<String> categories = new ArrayList<String>();
            if (root.has("categories") && root.get("categories").isArray()) {
                for (JsonNode cat : root.get("categories")) {
                    categories.add(cat.asText());
                }
            }
            EnumSet<PaymentMethod> paymentMethods = EnumSet.noneOf(PaymentMethod.class);
            if (root.has("paymentMethods") && root.get("paymentMethods").isArray()) {
                for (JsonNode pm : root.get("paymentMethods")) {
                    PaymentMethod.fromCode(pm.asText()).ifPresent(paymentMethods::add);
                }
            }
            return MerchantProfile.builder().active(active).categories(categories).storeDescription(this.getTextOrNull(root, "storeDescription")).location(this.getTextOrNull(root, "location")).operatingHours(this.getTextOrNull(root, "operatingHours")).paymentMethods(paymentMethods).build();
        }
        catch (Exception e) {
            LOGGER.warn("parse_merchant_profile_failed error={}", (Object)e.getMessage());
            return MerchantProfile.inactive();
        }
    }

    private String serializeMerchantProfile(MerchantProfile profile2) {
        try {
            ObjectNode node = JSON_MAPPER.createObjectNode();
            node.put("active", profile2.active());
            ArrayNode categoriesArray = node.putArray("categories");
            profile2.categories().forEach(categoriesArray::add);
            profile2.getStoreDescription().ifPresent(v -> node.put("storeDescription", (String)v));
            profile2.getLocation().ifPresent(v -> node.put("location", (String)v));
            profile2.getOperatingHours().ifPresent(v -> node.put("operatingHours", (String)v));
            ArrayNode paymentMethodsArray = node.putArray("paymentMethods");
            profile2.paymentMethods().stream().map(PaymentMethod::getCode).forEach(paymentMethodsArray::add);
            return JSON_MAPPER.writeValueAsString(node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize merchant profile", e);
        }
    }

    private GenericEvent toGenericEvent(NostrEvent event) {
        GenericEvent genericEvent = new GenericEvent();
        genericEvent.setKind(event.kind());
        genericEvent.setContent(event.content());
        genericEvent.setPubKey(new PublicKey(event.pubkey()));
        if (event.createdAt() != null) {
            genericEvent.setCreatedAt(event.createdAt());
        } else {
            genericEvent.setCreatedAt(Instant.now().getEpochSecond());
        }
        if (event.id() != null) {
            genericEvent.setId(event.id());
        }
        if (event.sig() != null) {
            genericEvent.setSignature(Signature.fromString(event.sig()));
        }
        ArrayList<BaseTag> nostrTags = new ArrayList<BaseTag>();
        for (Tag tag : event.tags()) {
            ArrayList<ElementAttribute> attrs = new ArrayList<ElementAttribute>();
            for (String element : tag.toList()) {
                attrs.add(new ElementAttribute(null, element));
            }
            nostrTags.add(new GenericTag(tag.type(), attrs));
        }
        genericEvent.setTags(nostrTags);
        return genericEvent;
    }

    private GenericEvent parseEventFromJson(String jsonMessage) {
        try {
            JsonNode root = JSON_MAPPER.readTree(jsonMessage);
            if (!root.isArray() || root.size() < 3 || !"EVENT".equals(root.get(0).asText())) {
                return null;
            }
            JsonNode eventNode = root.get(2);
            GenericEvent event = new GenericEvent();
            if (eventNode.has("id")) {
                event.setId(eventNode.get("id").asText());
            }
            if (eventNode.has("pubkey")) {
                event.setPubKey(new PublicKey(eventNode.get("pubkey").asText()));
            }
            if (eventNode.has("kind")) {
                event.setKind(eventNode.get("kind").asInt());
            }
            if (eventNode.has("content")) {
                event.setContent(eventNode.get("content").asText());
            }
            if (eventNode.has("created_at")) {
                event.setCreatedAt(eventNode.get("created_at").asLong());
            }
            if (eventNode.has("sig")) {
                event.setSignature(Signature.fromString(eventNode.get("sig").asText()));
            }
            if (eventNode.has("tags")) {
                ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
                for (JsonNode tagArray : eventNode.get("tags")) {
                    if (!tagArray.isArray() || tagArray.size() <= 0) continue;
                    ArrayList<ElementAttribute> attrs = new ArrayList<ElementAttribute>();
                    for (JsonNode element : tagArray) {
                        attrs.add(new ElementAttribute(null, element.asText()));
                    }
                    tags.add(new GenericTag(tagArray.get(0).asText(), attrs));
                }
                event.setTags(tags);
            }
            return event;
        }
        catch (Exception e) {
            LOGGER.warn("parse_event_json_failed error={}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean hasMatchingDTag(GenericEvent event, String expectedDTag) {
        if (event.getTags() == null) {
            return false;
        }
        for (BaseTag tag : event.getTags()) {
            Object attrValue;
            String dTagValue;
            List<ElementAttribute> attrs;
            GenericTag genericTag;
            if (!(tag instanceof GenericTag) || !"d".equals((genericTag = (GenericTag)tag).getCode()) || (attrs = genericTag.getAttributes()).size() < 2 || !expectedDTag.equals(dTagValue = (attrValue = attrs.get(1).value()) != null ? attrValue.toString() : null)) continue;
            return true;
        }
        return false;
    }

    private String getTextOrNull(JsonNode node, String field) {
        return node.has(field) && !node.get(field).isNull() ? node.get(field).asText() : null;
    }

    private void validateHexPubkey(String pubkey) {
        if (pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() <= 16) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }

    @Override
    public void close() {
        LOGGER.info("nostr_profile_adapter_closing clients={}", (Object)this.clientCache.size());
        this.clientCache.values().forEach(context -> {
            try {
                context.close();
            }
            catch (Exception e) {
                LOGGER.warn("close_client_error error={}", (Object)e.getMessage());
            }
        });
        this.clientCache.clear();
        LOGGER.info("nostr_profile_adapter_closed");
    }

    private record ClientContext(WebSocketClientIF webSocketClient, SpringWebSocketClient client) implements AutoCloseable
    {
        @Override
        public void close() {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

