/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.identity.api.ports.IdentityRepository;
import xyz.tcheeric.identity.domain.Identity;
import xyz.tcheeric.identity.domain.PublicKey;

public class InMemoryIdentityRepository
implements IdentityRepository {
    private final Map<String, Identity> identitiesById = new ConcurrentHashMap<String, Identity>();
    private final Map<String, String> publicKeyToId = new ConcurrentHashMap<String, String>();

    @Override
    public Optional<Identity> findById(String id) {
        return Optional.ofNullable(this.identitiesById.get(id));
    }

    @Override
    public Optional<Identity> findByPublicKey(PublicKey pubKey) {
        String pubKeyHex = pubKey.toNostrJava().toString();
        String id = this.publicKeyToId.get(pubKeyHex);
        if (id == null) {
            return Optional.empty();
        }
        return this.findById(id);
    }

    @Override
    public List<Identity> findAll() {
        return new ArrayList<Identity>(this.identitiesById.values());
    }

    @Override
    public void save(Identity identity) {
        this.identitiesById.put(identity.getId(), identity);
        String pubKeyHex = identity.getPublicKey().toNostrJava().toString();
        this.publicKeyToId.put(pubKeyHex, identity.getId());
    }

    @Override
    public void delete(String id) {
        Identity identity = this.identitiesById.remove(id);
        if (identity != null) {
            String pubKeyHex = identity.getPublicKey().toNostrJava().toString();
            this.publicKeyToId.remove(pubKeyHex);
        }
    }

    @Override
    public boolean exists(String id) {
        return this.identitiesById.containsKey(id);
    }

    public void clear() {
        this.identitiesById.clear();
        this.publicKeyToId.clear();
    }

    public int size() {
        return this.identitiesById.size();
    }
}

