/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.storage.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Objects;

public class IdentityMetadata {
    private final String identityId;
    private final String name;
    private final String publicKey;
    private final Instant createdAt;
    private final boolean isDefault;

    @JsonCreator
    public IdentityMetadata(@JsonProperty(value="identityId") String identityId, @JsonProperty(value="name") String name, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="createdAt") Instant createdAt, @JsonProperty(value="default") boolean isDefault) {
        this.identityId = identityId;
        this.name = name;
        this.publicKey = publicKey;
        this.createdAt = createdAt;
        this.isDefault = isDefault;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public String getName() {
        return this.name;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="default")
    public boolean isDefault() {
        return this.isDefault;
    }

    public IdentityMetadata withDefault(boolean isDefault) {
        return new IdentityMetadata(this.identityId, this.name, this.publicKey, this.createdAt, isDefault);
    }

    public IdentityMetadata withName(String name) {
        return new IdentityMetadata(this.identityId, name, this.publicKey, this.createdAt, this.isDefault);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMetadata that = (IdentityMetadata)o;
        return this.isDefault == that.isDefault && Objects.equals(this.identityId, that.identityId) && Objects.equals(this.name, that.name) && Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.createdAt, that.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.identityId, this.name, this.publicKey, this.createdAt, this.isDefault);
    }

    public String toString() {
        return "IdentityMetadata{identityId='" + this.identityId + "', name='" + this.name + "', publicKey='" + this.publicKey + "', createdAt=" + String.valueOf(this.createdAt) + ", isDefault=" + this.isDefault + "}";
    }
}

