/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.storage.file.encryption;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;

public class PasswordBasedEncryption {
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final String KEY_ALGORITHM = "AES";
    private static final String KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final int KEY_SIZE = 256;
    private static final int ITERATION_COUNT = 100000;
    private static final int SALT_LENGTH = 16;
    private static final int IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private final SecureRandom secureRandom = new SecureRandom();

    public byte[] encrypt(byte[] plaintext, char[] password) throws IdentityStorageException {
        try {
            byte[] salt = new byte[16];
            byte[] iv = new byte[12];
            this.secureRandom.nextBytes(salt);
            this.secureRandom.nextBytes(iv);
            SecretKey key = this.deriveKey(password, salt);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)key, gcmSpec);
            byte[] ciphertext = cipher.doFinal(plaintext);
            ByteBuffer buffer = ByteBuffer.allocate(28 + ciphertext.length);
            buffer.put(salt);
            buffer.put(iv);
            buffer.put(ciphertext);
            return buffer.array();
        }
        catch (Exception e) {
            throw new IdentityStorageException("Encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] encryptedData, char[] password) throws IdentityStorageException {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(encryptedData);
            byte[] salt = new byte[16];
            byte[] iv = new byte[12];
            buffer.get(salt);
            buffer.get(iv);
            byte[] ciphertext = new byte[buffer.remaining()];
            buffer.get(ciphertext);
            SecretKey key = this.deriveKey(password, salt);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)key, gcmSpec);
            return cipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            throw new IdentityStorageException("Decryption failed - wrong password or corrupted data", e);
        }
    }

    private SecretKey deriveKey(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 100000, 256);
        SecretKeyFactory factory2 = SecretKeyFactory.getInstance(KEY_DERIVATION_ALGORITHM);
        byte[] keyBytes = factory2.generateSecret(spec).getEncoded();
        return new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }

    public static int getIterationCount() {
        return 100000;
    }
}

