/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record DecryptMessageRequest(String requestId, String authToken, String ciphertext, String senderPubkey) implements IdentityMessage
{
    public DecryptMessageRequest {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        Objects.requireNonNull(authToken, "authToken cannot be null");
        Objects.requireNonNull(ciphertext, "ciphertext cannot be null");
        Objects.requireNonNull(senderPubkey, "senderPubkey cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (authToken.isBlank()) {
            throw new IllegalArgumentException("authToken cannot be blank");
        }
        if (ciphertext.isBlank()) {
            throw new IllegalArgumentException("ciphertext cannot be blank");
        }
        if (senderPubkey.isBlank()) {
            throw new IllegalArgumentException("senderPubkey cannot be blank");
        }
    }

    public static DecryptMessageRequest create(String requestId, String authToken, String ciphertext, String senderPubkey) {
        return new DecryptMessageRequest(requestId, authToken, ciphertext, senderPubkey);
    }
}

