/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record DecryptMessageResponse(String requestId, boolean success, String errorMessage, String plaintext, int version) implements IdentityMessage
{
    public DecryptMessageResponse {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (success) {
            if (plaintext == null) {
                throw new IllegalArgumentException("plaintext must be provided when success is true");
            }
            if (version != 4 && version != 44) {
                throw new IllegalArgumentException("version must be 4 (NIP-04) or 44 (NIP-44) when success is true");
            }
        }
        if (!success && (errorMessage == null || errorMessage.isBlank())) {
            throw new IllegalArgumentException("errorMessage should be provided when success is false");
        }
    }

    public static DecryptMessageResponse success(String requestId, String plaintext, int version) {
        return new DecryptMessageResponse(requestId, true, null, plaintext, version);
    }

    public static DecryptMessageResponse successNip44(String requestId, String plaintext) {
        return DecryptMessageResponse.success(requestId, plaintext, 44);
    }

    public static DecryptMessageResponse failure(String requestId, String errorMessage) {
        return new DecryptMessageResponse(requestId, false, errorMessage, null, 0);
    }
}

