/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record EncryptMessageResponse(String requestId, boolean success, String errorMessage, String ciphertext, int version) implements IdentityMessage
{
    public EncryptMessageResponse {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (success) {
            if (ciphertext == null || ciphertext.isBlank()) {
                throw new IllegalArgumentException("ciphertext must be provided when success is true");
            }
            if (version != 4 && version != 44) {
                throw new IllegalArgumentException("version must be 4 (NIP-04) or 44 (NIP-44) when success is true");
            }
        }
        if (!success && (errorMessage == null || errorMessage.isBlank())) {
            throw new IllegalArgumentException("errorMessage should be provided when success is false");
        }
    }

    public static EncryptMessageResponse success(String requestId, String ciphertext, int version) {
        return new EncryptMessageResponse(requestId, true, null, ciphertext, version);
    }

    public static EncryptMessageResponse successNip44(String requestId, String ciphertext) {
        return EncryptMessageResponse.success(requestId, ciphertext, 44);
    }

    public static EncryptMessageResponse failure(String requestId, String errorMessage) {
        return new EncryptMessageResponse(requestId, false, errorMessage, null, 0);
    }
}

