/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.List;
import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;
import xyz.tcheeric.messaging.messages.PublicKeyInfo;

public record ListPublicKeysResponse(String requestId, boolean success, String errorMessage, List<PublicKeyInfo> publicKeys) implements IdentityMessage
{
    public ListPublicKeysResponse {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (success) {
            Objects.requireNonNull(publicKeys, "publicKeys must be provided when success is true");
            publicKeys = List.copyOf(publicKeys);
        }
        if (!success && (errorMessage == null || errorMessage.isBlank())) {
            throw new IllegalArgumentException("errorMessage should be provided when success is false");
        }
    }

    public static ListPublicKeysResponse success(String requestId, List<PublicKeyInfo> publicKeys) {
        return new ListPublicKeysResponse(requestId, true, null, publicKeys);
    }

    public static ListPublicKeysResponse empty(String requestId) {
        return ListPublicKeysResponse.success(requestId, List.of());
    }

    public static ListPublicKeysResponse failure(String requestId, String errorMessage) {
        return new ListPublicKeysResponse(requestId, false, errorMessage, null);
    }
}

