/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.List;
import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record SignEventRequest(String requestId, String authToken, int kind, String content, List<List<String>> tags, long createdAt) implements IdentityMessage
{
    public SignEventRequest {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        Objects.requireNonNull(authToken, "authToken cannot be null");
        Objects.requireNonNull(content, "content cannot be null");
        Objects.requireNonNull(tags, "tags cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (authToken.isBlank()) {
            throw new IllegalArgumentException("authToken cannot be blank");
        }
        if (createdAt <= 0L) {
            throw new IllegalArgumentException("createdAt must be positive");
        }
        tags = List.copyOf(tags.stream().map(List::copyOf).toList());
    }

    public static SignEventRequest textNote(String requestId, String authToken, String content, long createdAt) {
        return new SignEventRequest(requestId, authToken, 1, content, List.of(), createdAt);
    }
}

