/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.admin;

import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Error;

public class AdminException
extends RuntimeException {
    private final String errorCode;
    private final String method;

    public AdminException(String message) {
        super(message);
        this.errorCode = null;
        this.method = null;
    }

    public AdminException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = null;
        this.method = null;
    }

    public AdminException(Nip46Error error, String method) {
        super(AdminException.formatErrorMessage(error, method));
        this.errorCode = error != null ? error.getCode() : null;
        this.method = method;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isAuthenticationError() {
        return "UNAUTHORIZED".equals(this.errorCode) || "AUTH_REQUIRED".equals(this.errorCode);
    }

    public boolean isPermissionError() {
        return "FORBIDDEN".equals(this.errorCode) || "PERMISSION_DENIED".equals(this.errorCode);
    }

    public boolean isNotFoundError() {
        return "NOT_FOUND".equals(this.errorCode);
    }

    private static String formatErrorMessage(Nip46Error error, String method) {
        if (error == null) {
            return "Admin operation failed: " + method;
        }
        StringBuilder sb = new StringBuilder();
        if (method != null) {
            sb.append(method).append(": ");
        }
        if (error.getCode() != null) {
            sb.append("[").append(error.getCode()).append("] ");
        }
        sb.append(error.getMessage());
        return sb.toString();
    }
}

