/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.admin.policy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.admin.AdminException;
import xyz.tcheeric.nsecbunker.admin.NsecBunkerAdminClient;
import xyz.tcheeric.nsecbunker.admin.policy.PolicyBuilder;
import xyz.tcheeric.nsecbunker.admin.policy.PolicyManager;
import xyz.tcheeric.nsecbunker.core.model.BunkerPolicy;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public class DefaultPolicyManager
implements PolicyManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPolicyManager.class);
    static final String METHOD_CREATE_POLICY = "create_new_policy";
    static final String METHOD_LIST_POLICIES = "get_policies";
    static final String METHOD_GET_POLICY = "get_policy";
    static final String METHOD_DELETE_POLICY = "delete_policy";
    private final NsecBunkerAdminClient adminClient;
    private final ObjectMapper objectMapper;

    public DefaultPolicyManager(NsecBunkerAdminClient adminClient) {
        this(adminClient, DefaultPolicyManager.createDefaultObjectMapper());
    }

    public DefaultPolicyManager(NsecBunkerAdminClient adminClient, ObjectMapper objectMapper) {
        this.adminClient = Objects.requireNonNull(adminClient, "adminClient must not be null");
        this.objectMapper = objectMapper != null ? objectMapper : DefaultPolicyManager.createDefaultObjectMapper();
    }

    @Override
    public CompletableFuture<BunkerPolicy> createPolicy(BunkerPolicy policy) {
        Objects.requireNonNull(policy, "policy must not be null");
        if (policy.getName() == null || policy.getName().isBlank()) {
            throw new IllegalArgumentException("Policy name must not be null or blank");
        }
        String payload = this.toJson(policy);
        return this.sendForResult(METHOD_CREATE_POLICY, List.of(payload), "create policy " + policy.getName()).thenCompose(result -> {
            if (result != null && result.contains("ok")) {
                return this.listPolicies().thenApply(policies -> {
                    BunkerPolicy found = policies.stream().filter(p -> policy.getName().equals(p.getName())).findFirst().orElse(null);
                    if (found == null) {
                        return policy;
                    }
                    BunkerPolicy.BunkerPolicyBuilder builder = found.toBuilder().active(true).clearRules();
                    if (policy.hasRules()) {
                        builder.rules(policy.getRules());
                    }
                    return builder.build();
                });
            }
            throw new AdminException("Failed to create policy: " + result);
        });
    }

    public CompletableFuture<BunkerPolicy> createPolicy(PolicyBuilder builder) {
        Objects.requireNonNull(builder, "builder must not be null");
        return this.createPolicy(builder.build());
    }

    @Override
    public CompletableFuture<List<BunkerPolicy>> listPolicies() {
        return this.sendForResult(METHOD_LIST_POLICIES, Collections.emptyList(), "list policies").thenApply(this::parsePolicyList);
    }

    @Override
    public CompletableFuture<BunkerPolicy> getPolicy(String policyId) {
        this.validateId(policyId);
        return this.sendForPolicy(METHOD_GET_POLICY, List.of(policyId), "get policy " + policyId);
    }

    @Override
    public CompletableFuture<Boolean> deletePolicy(String policyId) {
        this.validateId(policyId);
        return this.sendForResult(METHOD_DELETE_POLICY, List.of(policyId), "delete policy " + policyId).thenApply(ignored -> Boolean.TRUE);
    }

    private CompletableFuture<BunkerPolicy> sendForPolicy(String method, List<String> params, String description) {
        return this.sendForResult(method, params, description).thenApply(this::parsePolicy);
    }

    private CompletableFuture<String> sendForResult(String method, List<String> params, String description) {
        Nip46Request request = Nip46Request.builder().method(method).params(params != null ? List.copyOf(params) : Collections.emptyList()).build();
        return this.adminClient.sendRequest(request).thenApply(response -> this.unwrapResponse((Nip46Response)response, method, description));
    }

    private String unwrapResponse(Nip46Response response, String method, String description) {
        if (response == null) {
            throw new AdminException("Admin operation failed: " + description);
        }
        if (response.isError()) {
            throw new AdminException(response.getError(), method);
        }
        return response.getResult();
    }

    private BunkerPolicy parsePolicy(String result) {
        if (result == null || result.isBlank()) {
            throw new AdminException("Policy response was empty");
        }
        try {
            return this.objectMapper.readValue(result, BunkerPolicy.class);
        }
        catch (JsonProcessingException e) {
            throw new AdminException("Failed to parse policy: " + e.getMessage(), e);
        }
    }

    private List<BunkerPolicy> parsePolicyList(String result) {
        if (result == null || result.isBlank()) {
            return Collections.emptyList();
        }
        try {
            List<BunkerPolicy> policies = this.objectMapper.readValue(result, new TypeReference<List<BunkerPolicy>>(){});
            return List.copyOf(policies);
        }
        catch (JsonProcessingException e) {
            throw new AdminException("Failed to parse policy list: " + e.getMessage(), e);
        }
    }

    private String toJson(BunkerPolicy policy) {
        try {
            return this.objectMapper.writeValueAsString(policy);
        }
        catch (JsonProcessingException e) {
            throw new AdminException("Failed to serialize policy: " + e.getMessage(), e);
        }
    }

    private void validateId(String policyId) {
        if (policyId == null || policyId.isBlank()) {
            throw new IllegalArgumentException("Policy id must not be null or blank");
        }
    }

    static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule(new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }
}

