/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.admin.policy;

import java.time.Duration;
import xyz.tcheeric.nsecbunker.admin.policy.PolicyBuilder;
import xyz.tcheeric.nsecbunker.core.model.BunkerPolicy;
import xyz.tcheeric.nsecbunker.core.model.PolicyRule;

public final class PolicyTemplates {
    private PolicyTemplates() {
    }

    public static BunkerPolicy fullAccess(String name) {
        PolicyRule allowAll = PolicyRule.builder().type(PolicyRule.RuleType.ALLOW).build();
        return PolicyBuilder.withName(name).addRule(allowAll).description("Allows all operations").build();
    }

    public static BunkerPolicy readOnly(String name) {
        return PolicyBuilder.withName(name).allowMethod("get_public_key").allowMethod("ping").denyMethod("sign_event").description("Read-only: metadata only, no signing").build();
    }

    public static BunkerPolicy fullAccessExpiring(String name, Duration lifetime) {
        return PolicyBuilder.withName(name).addRule(PolicyRule.builder().type(PolicyRule.RuleType.ALLOW).build()).expiresIn(lifetime).description("Full access with expiration").build();
    }
}

