/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.client.request;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public final class RequestQueue {
    private final Map<String, CompletableFuture<Nip46Response>> pending = new ConcurrentHashMap<String, CompletableFuture<Nip46Response>>();

    public CompletableFuture<Nip46Response> register(Nip46Request request, Duration timeout2) {
        CompletableFuture<Nip46Response> future = new CompletableFuture<Nip46Response>();
        this.pending.put(request.getId(), future);
        if (timeout2 != null) {
            future.orTimeout(timeout2.toMillis(), TimeUnit.MILLISECONDS);
        }
        return future;
    }

    public boolean complete(Nip46Response response) {
        if (response == null || response.getId() == null) {
            return false;
        }
        CompletableFuture<Nip46Response> future = this.pending.remove(response.getId());
        if (future != null) {
            future.complete(response);
            return true;
        }
        return false;
    }

    public void cancel(String requestId) {
        CompletableFuture<Nip46Response> future = this.pending.remove(requestId);
        if (future != null) {
            future.cancel(true);
        }
    }

    public void cancelAll() {
        this.pending.values().forEach(future -> future.cancel(true));
        this.pending.clear();
    }

    public int size() {
        return this.pending.size();
    }
}

