/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.client.signer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.nsecbunker.client.signer.BatchSigner;
import xyz.tcheeric.nsecbunker.client.signer.RemoteSigner;

public final class DefaultBatchSigner
implements BatchSigner {
    private final RemoteSigner signer;

    public DefaultBatchSigner(RemoteSigner signer) {
        this.signer = Objects.requireNonNull(signer, "signer must not be null");
    }

    @Override
    public CompletableFuture<List<String>> signEvents(List<String> events) {
        if (events == null || events.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
        for (String event : events) {
            futures.add(this.signer.signEvent(event));
        }
        return this.executeBatch(futures);
    }

    @Override
    public CompletableFuture<List<String>> executeBatch(List<CompletableFuture<String>> operations) {
        if (operations == null || operations.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        CompletableFuture<Void> allDone = CompletableFuture.allOf(operations.toArray(new CompletableFuture[0]));
        return allDone.thenApply(ignored -> operations.stream().map(CompletableFuture::join).toList());
    }
}

