/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.client.signer;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import nostr.base.ISignable;
import nostr.base.PublicKey;
import nostr.base.Signature;
import xyz.tcheeric.nsecbunker.client.signer.RemoteSigner;
import xyz.tcheeric.nsecbunker.client.signer.exception.SignerAdapterException;

public final class NostrJavaSignerAdapter {
    private final RemoteSigner signer;

    public NostrJavaSignerAdapter(RemoteSigner signer) {
        this.signer = Objects.requireNonNull(signer, "signer must not be null");
    }

    public PublicKey getPublicKey() {
        String hex = this.signer.getPublicKey().join();
        return new PublicKey(hex);
    }

    public Signature sign(ISignable signable) {
        Objects.requireNonNull(signable, "signable must not be null");
        try {
            String payload = this.extractPayload(signable);
            String sig = this.signer.signEvent(payload).join();
            Signature signature = Signature.fromString(sig);
            signable.setSignature(signature);
            return signature;
        }
        catch (Exception e) {
            throw new SignerAdapterException("Failed to sign object: " + e.getMessage(), e);
        }
    }

    public CompletableFuture<ISignable> signAsync(ISignable signable) {
        Objects.requireNonNull(signable, "signable must not be null");
        String payload = this.extractPayload(signable);
        return this.signer.signEvent(payload).thenApply(sig -> {
            Signature signature = Signature.fromString(sig);
            signable.setSignature(signature);
            return signable;
        });
    }

    private String extractPayload(ISignable signable) {
        ByteBuffer buffer;
        if (signable.getByteArraySupplier() != null && (buffer = signable.getByteArraySupplier().get()) != null) {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return new String(bytes);
        }
        return signable.toString();
    }
}

