/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.client.signer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import nostr.crypto.bech32.Bech32;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.client.request.RequestExecutor;
import xyz.tcheeric.nsecbunker.client.request.RequestQueue;
import xyz.tcheeric.nsecbunker.client.signer.RemoteSigner;
import xyz.tcheeric.nsecbunker.client.signer.SignerConfig;
import xyz.tcheeric.nsecbunker.client.signer.SignerException;
import xyz.tcheeric.nsecbunker.client.signer.SignerState;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Decoder;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Encoder;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public class NsecBunkerSigner
implements RemoteSigner {
    private static final Logger log = LoggerFactory.getLogger(NsecBunkerSigner.class);
    private final SignerConfig config;
    private final Identity clientIdentity;
    private final Identity communicationIdentity;
    private final String bunkerPubkeyHex;
    private final Nip46Encoder encoder;
    private final Nip46Decoder decoder;
    private final Duration requestTimeout;
    private final AtomicBoolean connected;
    private final AtomicReference<SignerState> state;
    private final Function<Nip46Request, Nip46Response> requestHandler;
    private final RequestExecutor requestExecutor;
    private final Identity ephemeralIdentity;

    public NsecBunkerSigner(SignerConfig config) {
        this(config, null, new Nip46Encoder(), new Nip46Decoder());
    }

    public NsecBunkerSigner(SignerConfig config, Function<Nip46Request, Nip46Response> requestHandler, Nip46Encoder encoder, Nip46Decoder decoder) {
        this.config = Objects.requireNonNull(config, "config must not be null");
        this.requestHandler = requestHandler;
        this.encoder = encoder != null ? encoder : new Nip46Encoder();
        this.decoder = decoder != null ? decoder : new Nip46Decoder();
        this.connected = new AtomicBoolean(false);
        this.state = new AtomicReference<SignerState>(SignerState.DISCONNECTED);
        this.requestTimeout = config.getRequestTimeout();
        this.requestExecutor = requestHandler == null ? null : new RequestExecutor(new RequestQueue(), req -> CompletableFuture.supplyAsync(() -> (Nip46Response)requestHandler.apply((Nip46Request)req)), RequestExecutor.Config.builder().timeout(this.requestTimeout).build());
        config.validate();
        this.clientIdentity = this.createIdentity(config.getClientPrivateKey());
        if (config.isUseEphemeralKey()) {
            this.communicationIdentity = this.ephemeralIdentity = Identity.generateRandomIdentity();
        } else {
            this.ephemeralIdentity = null;
            this.communicationIdentity = this.clientIdentity;
        }
        this.bunkerPubkeyHex = this.resolvePubkeyToHex(config.getBunkerPubkey());
        log.debug("Signer initialized with comm pubkey {}", (Object)this.communicationIdentity.getPublicKey());
    }

    @Override
    public CompletableFuture<Void> connect() {
        Nip46Request connectRequest = Nip46Request.connect(this.communicationIdentity.getPublicKey().toString(), this.config.getSecret());
        return this.sendRequest(connectRequest).thenAccept(response -> {
            if (this.isAuthUrl(response.getResult())) {
                this.state.set(SignerState.AUTH_URL_REQUIRED);
                throw new SignerException("Authorization required: " + response.getResult());
            }
            if (!"ack".equalsIgnoreCase(response.getResult())) {
                throw new SignerException("Connect failed: " + response.getResult());
            }
            this.connected.set(true);
            this.state.set(SignerState.CONNECTED);
        });
    }

    @Override
    public CompletableFuture<Void> disconnect() {
        this.connected.set(false);
        this.state.set(SignerState.DISCONNECTED);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
        this.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    public SignerState getState() {
        return this.state.get();
    }

    @Override
    public CompletableFuture<String> requestPermissions(List<String> methods) {
        ArrayList<Object> params = methods == null ? Collections.emptyList() : new ArrayList<Object>(methods);
        Nip46Request request = Nip46Request.builder().method("request_permissions").params(params).build();
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> signEvent(String eventJson) {
        Objects.requireNonNull(eventJson, "eventJson must not be null");
        Nip46Request request = Nip46Request.signEvent(eventJson);
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> getPublicKey() {
        Nip46Request request = Nip46Request.getPublicKey();
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> nip04Encrypt(String pubkeyHex, String plaintext) {
        Nip46Request request = Nip46Request.nip04Encrypt(pubkeyHex, plaintext);
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> nip04Decrypt(String pubkeyHex, String ciphertext) {
        Nip46Request request = Nip46Request.nip04Decrypt(pubkeyHex, ciphertext);
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> nip44Encrypt(String pubkeyHex, String plaintext) {
        Nip46Request request = Nip46Request.nip44Encrypt(pubkeyHex, plaintext);
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> nip44Decrypt(String pubkeyHex, String ciphertext) {
        Nip46Request request = Nip46Request.nip44Decrypt(pubkeyHex, ciphertext);
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    @Override
    public CompletableFuture<String> ping() {
        Nip46Request request = Nip46Request.ping();
        return this.sendRequest(request).thenApply(Nip46Response::getResult);
    }

    private boolean isAuthUrl(String result) {
        return result != null && result.startsWith("auth_url:");
    }

    private CompletableFuture<Nip46Response> sendRequest(Nip46Request request) {
        if (this.requestExecutor == null) {
            return CompletableFuture.failedFuture(new UnsupportedOperationException("No request handler configured for NsecBunkerSigner"));
        }
        return this.requestExecutor.execute(request).exceptionally(ex -> {
            throw new SignerException("Request failed: " + ex.getMessage(), (Throwable)ex);
        });
    }

    private Identity createIdentity(String privateKey) {
        String hexKey = privateKey;
        if (privateKey.startsWith("nsec1")) {
            try {
                hexKey = Bech32.fromBech32(privateKey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid nsec: " + privateKey, e);
            }
        }
        return Identity.create(hexKey);
    }

    private String resolvePubkeyToHex(String pubkey) {
        if (pubkey.startsWith("npub1")) {
            try {
                return Bech32.fromBech32(pubkey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid npub: " + pubkey, e);
            }
        }
        return pubkey;
    }

    public Identity getCommunicationIdentity() {
        return this.communicationIdentity;
    }

    public Identity getEphemeralIdentity() {
        return this.ephemeralIdentity;
    }
}

