/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.client.signer;

import java.time.Duration;
import java.util.List;

public final class SignerConfig {
    private final String bunkerPubkey;
    private final List<String> relays;
    private final String secret;
    private final String token;
    private final String clientPrivateKey;
    private final Duration connectTimeout;
    private final Duration requestTimeout;
    private final boolean useEphemeralKey;
    private final String bunkerToken;

    public void validate() {
        if (this.bunkerPubkey == null || this.bunkerPubkey.isBlank()) {
            throw new IllegalStateException("Bunker public key is required");
        }
        if (this.clientPrivateKey == null || this.clientPrivateKey.isBlank()) {
            throw new IllegalStateException("Client private key is required");
        }
        if (this.relays == null || this.relays.isEmpty()) {
            throw new IllegalStateException("At least one relay URL is required");
        }
    }

    private static List<String> $default$relays() {
        return List.of();
    }

    private static Duration $default$connectTimeout() {
        return Duration.ofSeconds(30L);
    }

    private static Duration $default$requestTimeout() {
        return Duration.ofSeconds(60L);
    }

    private static boolean $default$useEphemeralKey() {
        return true;
    }

    SignerConfig(String bunkerPubkey, List<String> relays, String secret, String token, String clientPrivateKey, Duration connectTimeout, Duration requestTimeout, boolean useEphemeralKey, String bunkerToken) {
        this.bunkerPubkey = bunkerPubkey;
        this.relays = relays;
        this.secret = secret;
        this.token = token;
        this.clientPrivateKey = clientPrivateKey;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.useEphemeralKey = useEphemeralKey;
        this.bunkerToken = bunkerToken;
    }

    public static SignerConfigBuilder builder() {
        return new SignerConfigBuilder();
    }

    public SignerConfigBuilder toBuilder() {
        return new SignerConfigBuilder().bunkerPubkey(this.bunkerPubkey).relays(this.relays).secret(this.secret).token(this.token).clientPrivateKey(this.clientPrivateKey).connectTimeout(this.connectTimeout).requestTimeout(this.requestTimeout).useEphemeralKey(this.useEphemeralKey).bunkerToken(this.bunkerToken);
    }

    public String getBunkerPubkey() {
        return this.bunkerPubkey;
    }

    public List<String> getRelays() {
        return this.relays;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getToken() {
        return this.token;
    }

    public String getClientPrivateKey() {
        return this.clientPrivateKey;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isUseEphemeralKey() {
        return this.useEphemeralKey;
    }

    public String getBunkerToken() {
        return this.bunkerToken;
    }

    public String toString() {
        return "SignerConfig(bunkerPubkey=" + this.getBunkerPubkey() + ", relays=" + String.valueOf(this.getRelays()) + ", token=" + this.getToken() + ", clientPrivateKey=" + this.getClientPrivateKey() + ", connectTimeout=" + String.valueOf(this.getConnectTimeout()) + ", requestTimeout=" + String.valueOf(this.getRequestTimeout()) + ", useEphemeralKey=" + this.isUseEphemeralKey() + ", bunkerToken=" + this.getBunkerToken() + ")";
    }

    public static class SignerConfigBuilder {
        private String bunkerPubkey;
        private boolean relays$set;
        private List<String> relays$value;
        private String secret;
        private String token;
        private String clientPrivateKey;
        private boolean connectTimeout$set;
        private Duration connectTimeout$value;
        private boolean requestTimeout$set;
        private Duration requestTimeout$value;
        private boolean useEphemeralKey$set;
        private boolean useEphemeralKey$value;
        private String bunkerToken;

        SignerConfigBuilder() {
        }

        public SignerConfigBuilder bunkerPubkey(String bunkerPubkey) {
            this.bunkerPubkey = bunkerPubkey;
            return this;
        }

        public SignerConfigBuilder relays(List<String> relays) {
            this.relays$value = relays;
            this.relays$set = true;
            return this;
        }

        public SignerConfigBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public SignerConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public SignerConfigBuilder clientPrivateKey(String clientPrivateKey) {
            this.clientPrivateKey = clientPrivateKey;
            return this;
        }

        public SignerConfigBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        public SignerConfigBuilder requestTimeout(Duration requestTimeout) {
            this.requestTimeout$value = requestTimeout;
            this.requestTimeout$set = true;
            return this;
        }

        public SignerConfigBuilder useEphemeralKey(boolean useEphemeralKey) {
            this.useEphemeralKey$value = useEphemeralKey;
            this.useEphemeralKey$set = true;
            return this;
        }

        public SignerConfigBuilder bunkerToken(String bunkerToken) {
            this.bunkerToken = bunkerToken;
            return this;
        }

        public SignerConfig build() {
            List<String> relays$value = this.relays$value;
            if (!this.relays$set) {
                relays$value = SignerConfig.$default$relays();
            }
            Duration connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = SignerConfig.$default$connectTimeout();
            }
            Duration requestTimeout$value = this.requestTimeout$value;
            if (!this.requestTimeout$set) {
                requestTimeout$value = SignerConfig.$default$requestTimeout();
            }
            boolean useEphemeralKey$value = this.useEphemeralKey$value;
            if (!this.useEphemeralKey$set) {
                useEphemeralKey$value = SignerConfig.$default$useEphemeralKey();
            }
            return new SignerConfig(this.bunkerPubkey, relays$value, this.secret, this.token, this.clientPrivateKey, connectTimeout$value, requestTimeout$value, useEphemeralKey$value, this.bunkerToken);
        }

        public String toString() {
            return "SignerConfig.SignerConfigBuilder(bunkerPubkey=" + this.bunkerPubkey + ", relays$value=" + String.valueOf(this.relays$value) + ", secret=" + this.secret + ", token=" + this.token + ", clientPrivateKey=" + this.clientPrivateKey + ", connectTimeout$value=" + String.valueOf(this.connectTimeout$value) + ", requestTimeout$value=" + String.valueOf(this.requestTimeout$value) + ", useEphemeralKey$value=" + this.useEphemeralKey$value + ", bunkerToken=" + this.bunkerToken + ")";
        }
    }
}

