/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import xyz.tcheeric.nsecbunker.connection.ConnectionState;

public class ConnectionHealth {
    private final String url;
    private final ConnectionState state;
    private final boolean healthy;
    private final Duration latency;
    private final Duration averageLatency;
    private final Duration minLatency;
    private final Duration maxLatency;
    private final Instant timestamp;
    private final Instant lastPingTime;
    private final Instant lastPongTime;
    private final Instant connectedSince;
    private final long successfulPings;
    private final long failedPings;
    private final int consecutiveFailures;
    private final long messagesSent;
    private final long messagesReceived;

    public double getPingSuccessRate() {
        long total = this.successfulPings + this.failedPings;
        if (total == 0L) {
            return 1.0;
        }
        return (double)this.successfulPings / (double)total;
    }

    public Optional<Duration> getUptime() {
        if (this.connectedSince == null || this.state != ConnectionState.CONNECTED) {
            return Optional.empty();
        }
        return Optional.of(Duration.between(this.connectedSince, Instant.now()));
    }

    public Optional<Duration> getTimeSinceLastPong() {
        if (this.lastPongTime == null) {
            return Optional.empty();
        }
        return Optional.of(Duration.between(this.lastPongTime, Instant.now()));
    }

    public static ConnectionHealth disconnected(String url) {
        return ConnectionHealth.builder().url(url).state(ConnectionState.DISCONNECTED).healthy(false).timestamp(Instant.now()).build();
    }

    public static ConnectionHealth connected(String url) {
        Instant now = Instant.now();
        return ConnectionHealth.builder().url(url).state(ConnectionState.CONNECTED).healthy(true).timestamp(now).connectedSince(now).successfulPings(0L).failedPings(0L).consecutiveFailures(0).messagesSent(0L).messagesReceived(0L).build();
    }

    public String toString() {
        return "ConnectionHealth{url='" + this.url + "', state=" + String.valueOf((Object)this.state) + ", healthy=" + this.healthy + ", latency=" + String.valueOf(this.latency) + ", avgLatency=" + String.valueOf(this.averageLatency) + ", successRate=" + String.format("%.1f%%", this.getPingSuccessRate() * 100.0) + "}";
    }

    ConnectionHealth(String url, ConnectionState state, boolean healthy, Duration latency, Duration averageLatency, Duration minLatency, Duration maxLatency, Instant timestamp, Instant lastPingTime, Instant lastPongTime, Instant connectedSince, long successfulPings, long failedPings, int consecutiveFailures, long messagesSent, long messagesReceived) {
        this.url = url;
        this.state = state;
        this.healthy = healthy;
        this.latency = latency;
        this.averageLatency = averageLatency;
        this.minLatency = minLatency;
        this.maxLatency = maxLatency;
        this.timestamp = timestamp;
        this.lastPingTime = lastPingTime;
        this.lastPongTime = lastPongTime;
        this.connectedSince = connectedSince;
        this.successfulPings = successfulPings;
        this.failedPings = failedPings;
        this.consecutiveFailures = consecutiveFailures;
        this.messagesSent = messagesSent;
        this.messagesReceived = messagesReceived;
    }

    public static ConnectionHealthBuilder builder() {
        return new ConnectionHealthBuilder();
    }

    public ConnectionHealthBuilder toBuilder() {
        return new ConnectionHealthBuilder().url(this.url).state(this.state).healthy(this.healthy).latency(this.latency).averageLatency(this.averageLatency).minLatency(this.minLatency).maxLatency(this.maxLatency).timestamp(this.timestamp).lastPingTime(this.lastPingTime).lastPongTime(this.lastPongTime).connectedSince(this.connectedSince).successfulPings(this.successfulPings).failedPings(this.failedPings).consecutiveFailures(this.consecutiveFailures).messagesSent(this.messagesSent).messagesReceived(this.messagesReceived);
    }

    public String getUrl() {
        return this.url;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public Duration getLatency() {
        return this.latency;
    }

    public Duration getAverageLatency() {
        return this.averageLatency;
    }

    public Duration getMinLatency() {
        return this.minLatency;
    }

    public Duration getMaxLatency() {
        return this.maxLatency;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Instant getLastPingTime() {
        return this.lastPingTime;
    }

    public Instant getLastPongTime() {
        return this.lastPongTime;
    }

    public Instant getConnectedSince() {
        return this.connectedSince;
    }

    public long getSuccessfulPings() {
        return this.successfulPings;
    }

    public long getFailedPings() {
        return this.failedPings;
    }

    public int getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    public long getMessagesSent() {
        return this.messagesSent;
    }

    public long getMessagesReceived() {
        return this.messagesReceived;
    }

    public static class ConnectionHealthBuilder {
        private String url;
        private ConnectionState state;
        private boolean healthy;
        private Duration latency;
        private Duration averageLatency;
        private Duration minLatency;
        private Duration maxLatency;
        private Instant timestamp;
        private Instant lastPingTime;
        private Instant lastPongTime;
        private Instant connectedSince;
        private long successfulPings;
        private long failedPings;
        private int consecutiveFailures;
        private long messagesSent;
        private long messagesReceived;

        ConnectionHealthBuilder() {
        }

        public ConnectionHealthBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ConnectionHealthBuilder state(ConnectionState state) {
            this.state = state;
            return this;
        }

        public ConnectionHealthBuilder healthy(boolean healthy) {
            this.healthy = healthy;
            return this;
        }

        public ConnectionHealthBuilder latency(Duration latency) {
            this.latency = latency;
            return this;
        }

        public ConnectionHealthBuilder averageLatency(Duration averageLatency) {
            this.averageLatency = averageLatency;
            return this;
        }

        public ConnectionHealthBuilder minLatency(Duration minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public ConnectionHealthBuilder maxLatency(Duration maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public ConnectionHealthBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ConnectionHealthBuilder lastPingTime(Instant lastPingTime) {
            this.lastPingTime = lastPingTime;
            return this;
        }

        public ConnectionHealthBuilder lastPongTime(Instant lastPongTime) {
            this.lastPongTime = lastPongTime;
            return this;
        }

        public ConnectionHealthBuilder connectedSince(Instant connectedSince) {
            this.connectedSince = connectedSince;
            return this;
        }

        public ConnectionHealthBuilder successfulPings(long successfulPings) {
            this.successfulPings = successfulPings;
            return this;
        }

        public ConnectionHealthBuilder failedPings(long failedPings) {
            this.failedPings = failedPings;
            return this;
        }

        public ConnectionHealthBuilder consecutiveFailures(int consecutiveFailures) {
            this.consecutiveFailures = consecutiveFailures;
            return this;
        }

        public ConnectionHealthBuilder messagesSent(long messagesSent) {
            this.messagesSent = messagesSent;
            return this;
        }

        public ConnectionHealthBuilder messagesReceived(long messagesReceived) {
            this.messagesReceived = messagesReceived;
            return this;
        }

        public ConnectionHealth build() {
            return new ConnectionHealth(this.url, this.state, this.healthy, this.latency, this.averageLatency, this.minLatency, this.maxLatency, this.timestamp, this.lastPingTime, this.lastPongTime, this.connectedSince, this.successfulPings, this.failedPings, this.consecutiveFailures, this.messagesSent, this.messagesReceived);
        }

        public String toString() {
            return "ConnectionHealth.ConnectionHealthBuilder(url=" + this.url + ", state=" + String.valueOf((Object)this.state) + ", healthy=" + this.healthy + ", latency=" + String.valueOf(this.latency) + ", averageLatency=" + String.valueOf(this.averageLatency) + ", minLatency=" + String.valueOf(this.minLatency) + ", maxLatency=" + String.valueOf(this.maxLatency) + ", timestamp=" + String.valueOf(this.timestamp) + ", lastPingTime=" + String.valueOf(this.lastPingTime) + ", lastPongTime=" + String.valueOf(this.lastPongTime) + ", connectedSince=" + String.valueOf(this.connectedSince) + ", successfulPings=" + this.successfulPings + ", failedPings=" + this.failedPings + ", consecutiveFailures=" + this.consecutiveFailures + ", messagesSent=" + this.messagesSent + ", messagesReceived=" + this.messagesReceived + ")";
        }
    }
}

