/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import xyz.tcheeric.nsecbunker.connection.ReconnectionStrategy;

public final class ExponentialBackoffStrategy
implements ReconnectionStrategy {
    private static final Duration DEFAULT_INITIAL_DELAY = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_MAX_DELAY = Duration.ofMinutes(5L);
    private static final double DEFAULT_MULTIPLIER = 2.0;
    private static final int DEFAULT_MAX_ATTEMPTS = 10;
    private static final double DEFAULT_JITTER = 0.1;
    private final Duration initialDelay;
    private final Duration maxDelay;
    private final double multiplier;
    private final int maxAttempts;
    private final double jitter;

    private ExponentialBackoffStrategy(Builder builder) {
        this.initialDelay = builder.initialDelay;
        this.maxDelay = builder.maxDelay;
        this.multiplier = builder.multiplier;
        this.maxAttempts = builder.maxAttempts;
        this.jitter = builder.jitter;
    }

    @Override
    public boolean shouldReconnect(int attempt) {
        if (this.maxAttempts == -1) {
            return true;
        }
        return attempt <= this.maxAttempts;
    }

    @Override
    public Optional<Duration> getDelay(int attempt) {
        if (!this.shouldReconnect(attempt)) {
            return Optional.empty();
        }
        double delayMillis = (double)this.initialDelay.toMillis() * Math.pow(this.multiplier, attempt - 1);
        delayMillis = Math.min(delayMillis, (double)this.maxDelay.toMillis());
        if (this.jitter > 0.0) {
            double jitterFactor = 1.0 - this.jitter + ThreadLocalRandom.current().nextDouble() * 2.0 * this.jitter;
            delayMillis *= jitterFactor;
        }
        return Optional.of(Duration.ofMillis(Math.round(delayMillis)));
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getJitter() {
        return this.jitter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ExponentialBackoffStrategy{initialDelay=" + String.valueOf(this.initialDelay) + ", maxDelay=" + String.valueOf(this.maxDelay) + ", multiplier=" + this.multiplier + ", maxAttempts=" + String.valueOf(this.maxAttempts == -1 ? "unlimited" : Integer.valueOf(this.maxAttempts)) + ", jitter=" + this.jitter + "}";
    }

    public static final class Builder {
        private Duration initialDelay = DEFAULT_INITIAL_DELAY;
        private Duration maxDelay = DEFAULT_MAX_DELAY;
        private double multiplier = 2.0;
        private int maxAttempts = 10;
        private double jitter = 0.1;

        private Builder() {
        }

        public Builder initialDelay(Duration initialDelay) {
            Objects.requireNonNull(initialDelay, "Initial delay must not be null");
            if (initialDelay.isNegative() || initialDelay.isZero()) {
                throw new IllegalArgumentException("Initial delay must be positive");
            }
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder maxDelay(Duration maxDelay) {
            Objects.requireNonNull(maxDelay, "Max delay must not be null");
            if (maxDelay.isNegative() || maxDelay.isZero()) {
                throw new IllegalArgumentException("Max delay must be positive");
            }
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder multiplier(double multiplier) {
            if (multiplier < 1.0) {
                throw new IllegalArgumentException("Multiplier must be >= 1.0");
            }
            this.multiplier = multiplier;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            if (maxAttempts < -1) {
                throw new IllegalArgumentException("Max attempts must be -1 (unlimited) or greater");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder unlimitedAttempts() {
            this.maxAttempts = -1;
            return this;
        }

        public Builder jitter(double jitter) {
            if (jitter < 0.0 || jitter > 1.0) {
                throw new IllegalArgumentException("Jitter must be between 0.0 and 1.0");
            }
            this.jitter = jitter;
            return this;
        }

        public Builder noJitter() {
            this.jitter = 0.0;
            return this;
        }

        public ExponentialBackoffStrategy build() {
            if (this.maxDelay.compareTo(this.initialDelay) < 0) {
                throw new IllegalStateException("Max delay must be >= initial delay");
            }
            return new ExponentialBackoffStrategy(this);
        }
    }
}

