/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import xyz.tcheeric.nsecbunker.connection.ReconnectionStrategy;

public final class FixedDelayStrategy
implements ReconnectionStrategy {
    private final Duration delay;
    private final int maxAttempts;

    public FixedDelayStrategy(Duration delay, int maxAttempts) {
        Objects.requireNonNull(delay, "Delay must not be null");
        if (delay.isNegative() || delay.isZero()) {
            throw new IllegalArgumentException("Delay must be positive");
        }
        if (maxAttempts < -1) {
            throw new IllegalArgumentException("Max attempts must be -1 (unlimited) or greater");
        }
        this.delay = delay;
        this.maxAttempts = maxAttempts;
    }

    @Override
    public boolean shouldReconnect(int attempt) {
        if (this.maxAttempts == -1) {
            return true;
        }
        return attempt <= this.maxAttempts;
    }

    @Override
    public Optional<Duration> getDelay(int attempt) {
        if (!this.shouldReconnect(attempt)) {
            return Optional.empty();
        }
        return Optional.of(this.delay);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public String toString() {
        return "FixedDelayStrategy{delay=" + String.valueOf(this.delay) + ", maxAttempts=" + String.valueOf(this.maxAttempts == -1 ? "unlimited" : Integer.valueOf(this.maxAttempts)) + "}";
    }
}

