/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.connection.ConnectionListener;
import xyz.tcheeric.nsecbunker.connection.ConnectionState;

public class LoggingConnectionListener
implements ConnectionListener {
    private final Logger log;

    public LoggingConnectionListener(String loggerName) {
        this.log = LoggerFactory.getLogger(loggerName);
    }

    public LoggingConnectionListener(Logger logger) {
        this.log = logger;
    }

    @Override
    public void onConnected(String url) {
        this.log.info("Connected to relay: {}", (Object)url);
    }

    @Override
    public void onDisconnected(String url, int code, String reason) {
        this.log.info("Disconnected from relay: {} (code={}, reason={})", url, code, reason);
    }

    @Override
    public void onError(String url, Throwable error) {
        this.log.error("Connection error on {}: {}", url, error.getMessage(), error);
    }

    @Override
    public void onStateChanged(String url, ConnectionState oldState, ConnectionState newState) {
        this.log.debug("State change on {}: {} -> {}", new Object[]{url, oldState, newState});
    }

    @Override
    public void onReconnecting(String url, int attempt) {
        this.log.info("Reconnecting to {} (attempt {})", (Object)url, (Object)attempt);
    }
}

