/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import java.time.Duration;
import java.util.Optional;
import xyz.tcheeric.nsecbunker.connection.ExponentialBackoffStrategy;
import xyz.tcheeric.nsecbunker.connection.FixedDelayStrategy;
import xyz.tcheeric.nsecbunker.connection.NoReconnectionStrategy;

public interface ReconnectionStrategy {
    public boolean shouldReconnect(int var1);

    public Optional<Duration> getDelay(int var1);

    public int getMaxAttempts();

    default public void reset() {
    }

    default public void onAttemptFailed(int attempt, Throwable error) {
    }

    public static ReconnectionStrategy none() {
        return NoReconnectionStrategy.INSTANCE;
    }

    public static ReconnectionStrategy fixedDelay(Duration delay, int maxAttempts) {
        return new FixedDelayStrategy(delay, maxAttempts);
    }

    public static ReconnectionStrategy fixedDelay(Duration delay) {
        return new FixedDelayStrategy(delay, -1);
    }

    public static ExponentialBackoffStrategy.Builder exponentialBackoff() {
        return ExponentialBackoffStrategy.builder();
    }

    public static ReconnectionStrategy exponentialBackoffDefault() {
        return ExponentialBackoffStrategy.builder().build();
    }
}

