/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.Instant;
import xyz.tcheeric.nsecbunker.core.model.BunkerPolicy;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=AccessTokenBuilder.class)
public final class AccessToken {
    private final String id;
    private final String token;
    @JsonProperty(value="key_name")
    private final String keyName;
    @JsonProperty(value="key_npub")
    private final String keyNpub;
    @JsonProperty(value="client_name")
    private final String clientName;
    private final BunkerPolicy policy;
    @JsonProperty(value="policy_id")
    private final String policyId;
    @JsonProperty(value="policy_name")
    private final String policyName;
    @JsonProperty(value="created_at")
    private final Instant createdAt;
    @JsonProperty(value="updated_at")
    private final Instant updatedAt;
    @JsonProperty(value="expires_at")
    private final Instant expiresAt;
    @JsonProperty(value="last_used_at")
    private final Instant lastUsedAt;
    @JsonProperty(value="redeemed_at")
    private final Instant redeemedAt;
    @JsonProperty(value="redeemed_by")
    private final String redeemedBy;
    @JsonProperty(value="time_until_expiration")
    private final Long timeUntilExpirationSeconds;
    @JsonProperty(value="usage_count")
    private final long usageCount;
    @JsonProperty(value="max_usage")
    private final Long maxUsage;
    @JsonAlias(value={"is_revoked"})
    private final boolean revoked;
    private final String relay;

    public static AccessTokenBuilder forKey(String keyName) {
        return AccessToken.builder().keyName(keyName);
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().isAfter(this.expiresAt);
    }

    public boolean isValid() {
        if (this.revoked) {
            return false;
        }
        if (this.isExpired()) {
            return false;
        }
        return this.maxUsage == null || this.usageCount < this.maxUsage;
    }

    public Duration getTimeUntilExpiration() {
        if (this.expiresAt == null) {
            return null;
        }
        Duration remaining = Duration.between(Instant.now(), this.expiresAt);
        return remaining.isNegative() ? Duration.ZERO : remaining;
    }

    public long getRemainingUsage() {
        if (this.maxUsage == null) {
            return -1L;
        }
        return Math.max(0L, this.maxUsage - this.usageCount);
    }

    public boolean hasUsageLimit() {
        return this.maxUsage != null;
    }

    public boolean hasPolicy() {
        return this.policy != null || this.policyId != null && !this.policyId.isEmpty();
    }

    public String getConnectionString() {
        if (this.keyNpub == null || this.token == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("bunker").append("://").append(this.keyNpub);
        if (this.relay != null && !this.relay.isEmpty()) {
            sb.append("?relay=").append(this.relay);
            sb.append("&secret=").append(this.token);
        } else {
            sb.append("?secret=").append(this.token);
        }
        return sb.toString();
    }

    public String getFullToken() {
        return this.token;
    }

    private static long $default$usageCount() {
        return 0L;
    }

    private static boolean $default$revoked() {
        return false;
    }

    AccessToken(String id, String token, String keyName, String keyNpub, String clientName, BunkerPolicy policy, String policyId, String policyName, Instant createdAt, Instant updatedAt, Instant expiresAt, Instant lastUsedAt, Instant redeemedAt, String redeemedBy, Long timeUntilExpirationSeconds, long usageCount, Long maxUsage, boolean revoked, String relay) {
        this.id = id;
        this.token = token;
        this.keyName = keyName;
        this.keyNpub = keyNpub;
        this.clientName = clientName;
        this.policy = policy;
        this.policyId = policyId;
        this.policyName = policyName;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.expiresAt = expiresAt;
        this.lastUsedAt = lastUsedAt;
        this.redeemedAt = redeemedAt;
        this.redeemedBy = redeemedBy;
        this.timeUntilExpirationSeconds = timeUntilExpirationSeconds;
        this.usageCount = usageCount;
        this.maxUsage = maxUsage;
        this.revoked = revoked;
        this.relay = relay;
    }

    public static AccessTokenBuilder builder() {
        return new AccessTokenBuilder();
    }

    public AccessTokenBuilder toBuilder() {
        return new AccessTokenBuilder().id(this.id).token(this.token).keyName(this.keyName).keyNpub(this.keyNpub).clientName(this.clientName).policy(this.policy).policyId(this.policyId).policyName(this.policyName).createdAt(this.createdAt).updatedAt(this.updatedAt).expiresAt(this.expiresAt).lastUsedAt(this.lastUsedAt).redeemedAt(this.redeemedAt).redeemedBy(this.redeemedBy).timeUntilExpirationSeconds(this.timeUntilExpirationSeconds).usageCount(this.usageCount).maxUsage(this.maxUsage).revoked(this.revoked).relay(this.relay);
    }

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeyNpub() {
        return this.keyNpub;
    }

    public String getClientName() {
        return this.clientName;
    }

    public BunkerPolicy getPolicy() {
        return this.policy;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public Instant getRedeemedAt() {
        return this.redeemedAt;
    }

    public String getRedeemedBy() {
        return this.redeemedBy;
    }

    public Long getTimeUntilExpirationSeconds() {
        return this.timeUntilExpirationSeconds;
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    public Long getMaxUsage() {
        return this.maxUsage;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public String getRelay() {
        return this.relay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        if (this.getUsageCount() != other.getUsageCount()) {
            return false;
        }
        if (this.isRevoked() != other.isRevoked()) {
            return false;
        }
        Long this$timeUntilExpirationSeconds = this.getTimeUntilExpirationSeconds();
        Long other$timeUntilExpirationSeconds = other.getTimeUntilExpirationSeconds();
        if (this$timeUntilExpirationSeconds == null ? other$timeUntilExpirationSeconds != null : !((Object)this$timeUntilExpirationSeconds).equals(other$timeUntilExpirationSeconds)) {
            return false;
        }
        Long this$maxUsage = this.getMaxUsage();
        Long other$maxUsage = other.getMaxUsage();
        if (this$maxUsage == null ? other$maxUsage != null : !((Object)this$maxUsage).equals(other$maxUsage)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$keyName = this.getKeyName();
        String other$keyName = other.getKeyName();
        if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
            return false;
        }
        String this$keyNpub = this.getKeyNpub();
        String other$keyNpub = other.getKeyNpub();
        if (this$keyNpub == null ? other$keyNpub != null : !this$keyNpub.equals(other$keyNpub)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        BunkerPolicy this$policy = this.getPolicy();
        BunkerPolicy other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        String this$policyName = this.getPolicyName();
        String other$policyName = other.getPolicyName();
        if (this$policyName == null ? other$policyName != null : !this$policyName.equals(other$policyName)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Instant this$expiresAt = this.getExpiresAt();
        Instant other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Instant this$lastUsedAt = this.getLastUsedAt();
        Instant other$lastUsedAt = other.getLastUsedAt();
        if (this$lastUsedAt == null ? other$lastUsedAt != null : !((Object)this$lastUsedAt).equals(other$lastUsedAt)) {
            return false;
        }
        Instant this$redeemedAt = this.getRedeemedAt();
        Instant other$redeemedAt = other.getRedeemedAt();
        if (this$redeemedAt == null ? other$redeemedAt != null : !((Object)this$redeemedAt).equals(other$redeemedAt)) {
            return false;
        }
        String this$redeemedBy = this.getRedeemedBy();
        String other$redeemedBy = other.getRedeemedBy();
        if (this$redeemedBy == null ? other$redeemedBy != null : !this$redeemedBy.equals(other$redeemedBy)) {
            return false;
        }
        String this$relay = this.getRelay();
        String other$relay = other.getRelay();
        return !(this$relay == null ? other$relay != null : !this$relay.equals(other$relay));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $usageCount = this.getUsageCount();
        result = result * 59 + (int)($usageCount >>> 32 ^ $usageCount);
        result = result * 59 + (this.isRevoked() ? 79 : 97);
        Long $timeUntilExpirationSeconds = this.getTimeUntilExpirationSeconds();
        result = result * 59 + ($timeUntilExpirationSeconds == null ? 43 : ((Object)$timeUntilExpirationSeconds).hashCode());
        Long $maxUsage = this.getMaxUsage();
        result = result * 59 + ($maxUsage == null ? 43 : ((Object)$maxUsage).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $keyName = this.getKeyName();
        result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
        String $keyNpub = this.getKeyNpub();
        result = result * 59 + ($keyNpub == null ? 43 : $keyNpub.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        BunkerPolicy $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        String $policyName = this.getPolicyName();
        result = result * 59 + ($policyName == null ? 43 : $policyName.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Instant $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Instant $lastUsedAt = this.getLastUsedAt();
        result = result * 59 + ($lastUsedAt == null ? 43 : ((Object)$lastUsedAt).hashCode());
        Instant $redeemedAt = this.getRedeemedAt();
        result = result * 59 + ($redeemedAt == null ? 43 : ((Object)$redeemedAt).hashCode());
        String $redeemedBy = this.getRedeemedBy();
        result = result * 59 + ($redeemedBy == null ? 43 : $redeemedBy.hashCode());
        String $relay = this.getRelay();
        result = result * 59 + ($relay == null ? 43 : $relay.hashCode());
        return result;
    }

    public String toString() {
        return "AccessToken(id=" + this.getId() + ", keyName=" + this.getKeyName() + ", keyNpub=" + this.getKeyNpub() + ", clientName=" + this.getClientName() + ", policy=" + String.valueOf(this.getPolicy()) + ", policyId=" + this.getPolicyId() + ", policyName=" + this.getPolicyName() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", expiresAt=" + String.valueOf(this.getExpiresAt()) + ", lastUsedAt=" + String.valueOf(this.getLastUsedAt()) + ", redeemedAt=" + String.valueOf(this.getRedeemedAt()) + ", redeemedBy=" + this.getRedeemedBy() + ", timeUntilExpirationSeconds=" + this.getTimeUntilExpirationSeconds() + ", usageCount=" + this.getUsageCount() + ", maxUsage=" + this.getMaxUsage() + ", revoked=" + this.isRevoked() + ", relay=" + this.getRelay() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class AccessTokenBuilder {
        private String id;
        private String token;
        private String keyName;
        private String keyNpub;
        private String clientName;
        private BunkerPolicy policy;
        private String policyId;
        private String policyName;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant expiresAt;
        private Instant lastUsedAt;
        private Instant redeemedAt;
        private String redeemedBy;
        private Long timeUntilExpirationSeconds;
        private boolean usageCount$set;
        private long usageCount$value;
        private Long maxUsage;
        private boolean revoked$set;
        private boolean revoked$value;
        private String relay;

        AccessTokenBuilder() {
        }

        public AccessTokenBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AccessTokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="key_name")
        public AccessTokenBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @JsonProperty(value="key_npub")
        public AccessTokenBuilder keyNpub(String keyNpub) {
            this.keyNpub = keyNpub;
            return this;
        }

        @JsonProperty(value="client_name")
        public AccessTokenBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public AccessTokenBuilder policy(BunkerPolicy policy) {
            this.policy = policy;
            return this;
        }

        @JsonProperty(value="policy_id")
        public AccessTokenBuilder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        @JsonProperty(value="policy_name")
        public AccessTokenBuilder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        @JsonProperty(value="created_at")
        public AccessTokenBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        public AccessTokenBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="expires_at")
        public AccessTokenBuilder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @JsonProperty(value="last_used_at")
        public AccessTokenBuilder lastUsedAt(Instant lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        @JsonProperty(value="redeemed_at")
        public AccessTokenBuilder redeemedAt(Instant redeemedAt) {
            this.redeemedAt = redeemedAt;
            return this;
        }

        @JsonProperty(value="redeemed_by")
        public AccessTokenBuilder redeemedBy(String redeemedBy) {
            this.redeemedBy = redeemedBy;
            return this;
        }

        @JsonProperty(value="time_until_expiration")
        public AccessTokenBuilder timeUntilExpirationSeconds(Long timeUntilExpirationSeconds) {
            this.timeUntilExpirationSeconds = timeUntilExpirationSeconds;
            return this;
        }

        @JsonProperty(value="usage_count")
        public AccessTokenBuilder usageCount(long usageCount) {
            this.usageCount$value = usageCount;
            this.usageCount$set = true;
            return this;
        }

        @JsonProperty(value="max_usage")
        public AccessTokenBuilder maxUsage(Long maxUsage) {
            this.maxUsage = maxUsage;
            return this;
        }

        @JsonAlias(value={"is_revoked"})
        public AccessTokenBuilder revoked(boolean revoked) {
            this.revoked$value = revoked;
            this.revoked$set = true;
            return this;
        }

        public AccessTokenBuilder relay(String relay) {
            this.relay = relay;
            return this;
        }

        public AccessToken build() {
            long usageCount$value = this.usageCount$value;
            if (!this.usageCount$set) {
                usageCount$value = AccessToken.$default$usageCount();
            }
            boolean revoked$value = this.revoked$value;
            if (!this.revoked$set) {
                revoked$value = AccessToken.$default$revoked();
            }
            return new AccessToken(this.id, this.token, this.keyName, this.keyNpub, this.clientName, this.policy, this.policyId, this.policyName, this.createdAt, this.updatedAt, this.expiresAt, this.lastUsedAt, this.redeemedAt, this.redeemedBy, this.timeUntilExpirationSeconds, usageCount$value, this.maxUsage, revoked$value, this.relay);
        }

        public String toString() {
            return "AccessToken.AccessTokenBuilder(id=" + this.id + ", token=" + this.token + ", keyName=" + this.keyName + ", keyNpub=" + this.keyNpub + ", clientName=" + this.clientName + ", policy=" + String.valueOf(this.policy) + ", policyId=" + this.policyId + ", policyName=" + this.policyName + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", expiresAt=" + String.valueOf(this.expiresAt) + ", lastUsedAt=" + String.valueOf(this.lastUsedAt) + ", redeemedAt=" + String.valueOf(this.redeemedAt) + ", redeemedBy=" + this.redeemedBy + ", timeUntilExpirationSeconds=" + this.timeUntilExpirationSeconds + ", usageCount$value=" + this.usageCount$value + ", maxUsage=" + this.maxUsage + ", revoked$value=" + this.revoked$value + ", relay=" + this.relay + ")";
        }
    }
}

