/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=BunkerKeyBuilder.class)
public final class BunkerKey {
    private final String name;
    private final String npub;
    @JsonProperty(value="pubkey")
    private final String pubkeyHex;
    private final boolean locked;
    @JsonProperty(value="user_count")
    private final int userCount;
    @JsonProperty(value="token_count")
    private final int tokenCount;
    @JsonProperty(value="signing_count")
    private final long signingCount;
    @JsonProperty(value="created_at")
    private final Instant createdAt;
    @JsonProperty(value="last_used_at")
    private final Instant lastUsedAt;
    private final String description;

    public static BunkerKeyBuilder withName(String name) {
        return BunkerKey.builder().name(name);
    }

    public String getPublicKey() {
        return this.pubkeyHex != null ? this.pubkeyHex : this.npub;
    }

    public boolean hasBeenUsed() {
        return this.signingCount > 0L || this.lastUsedAt != null;
    }

    public boolean hasUsers() {
        return this.userCount > 0;
    }

    public boolean hasTokens() {
        return this.tokenCount > 0;
    }

    private static boolean $default$locked() {
        return false;
    }

    private static int $default$userCount() {
        return 0;
    }

    private static int $default$tokenCount() {
        return 0;
    }

    private static long $default$signingCount() {
        return 0L;
    }

    BunkerKey(String name, String npub, String pubkeyHex, boolean locked, int userCount, int tokenCount, long signingCount, Instant createdAt, Instant lastUsedAt, String description) {
        this.name = name;
        this.npub = npub;
        this.pubkeyHex = pubkeyHex;
        this.locked = locked;
        this.userCount = userCount;
        this.tokenCount = tokenCount;
        this.signingCount = signingCount;
        this.createdAt = createdAt;
        this.lastUsedAt = lastUsedAt;
        this.description = description;
    }

    public static BunkerKeyBuilder builder() {
        return new BunkerKeyBuilder();
    }

    public BunkerKeyBuilder toBuilder() {
        return new BunkerKeyBuilder().name(this.name).npub(this.npub).pubkeyHex(this.pubkeyHex).locked(this.locked).userCount(this.userCount).tokenCount(this.tokenCount).signingCount(this.signingCount).createdAt(this.createdAt).lastUsedAt(this.lastUsedAt).description(this.description);
    }

    public String getName() {
        return this.name;
    }

    public String getNpub() {
        return this.npub;
    }

    public String getPubkeyHex() {
        return this.pubkeyHex;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public long getSigningCount() {
        return this.signingCount;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BunkerKey)) {
            return false;
        }
        BunkerKey other = (BunkerKey)o;
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        if (this.getUserCount() != other.getUserCount()) {
            return false;
        }
        if (this.getTokenCount() != other.getTokenCount()) {
            return false;
        }
        if (this.getSigningCount() != other.getSigningCount()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$npub = this.getNpub();
        String other$npub = other.getNpub();
        if (this$npub == null ? other$npub != null : !this$npub.equals(other$npub)) {
            return false;
        }
        String this$pubkeyHex = this.getPubkeyHex();
        String other$pubkeyHex = other.getPubkeyHex();
        if (this$pubkeyHex == null ? other$pubkeyHex != null : !this$pubkeyHex.equals(other$pubkeyHex)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$lastUsedAt = this.getLastUsedAt();
        Instant other$lastUsedAt = other.getLastUsedAt();
        if (this$lastUsedAt == null ? other$lastUsedAt != null : !((Object)this$lastUsedAt).equals(other$lastUsedAt)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLocked() ? 79 : 97);
        result = result * 59 + this.getUserCount();
        result = result * 59 + this.getTokenCount();
        long $signingCount = this.getSigningCount();
        result = result * 59 + (int)($signingCount >>> 32 ^ $signingCount);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $npub = this.getNpub();
        result = result * 59 + ($npub == null ? 43 : $npub.hashCode());
        String $pubkeyHex = this.getPubkeyHex();
        result = result * 59 + ($pubkeyHex == null ? 43 : $pubkeyHex.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $lastUsedAt = this.getLastUsedAt();
        result = result * 59 + ($lastUsedAt == null ? 43 : ((Object)$lastUsedAt).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "BunkerKey(name=" + this.getName() + ", npub=" + this.getNpub() + ", pubkeyHex=" + this.getPubkeyHex() + ", locked=" + this.isLocked() + ", userCount=" + this.getUserCount() + ", tokenCount=" + this.getTokenCount() + ", signingCount=" + this.getSigningCount() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", lastUsedAt=" + String.valueOf(this.getLastUsedAt()) + ", description=" + this.getDescription() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BunkerKeyBuilder {
        private String name;
        private String npub;
        private String pubkeyHex;
        private boolean locked$set;
        private boolean locked$value;
        private boolean userCount$set;
        private int userCount$value;
        private boolean tokenCount$set;
        private int tokenCount$value;
        private boolean signingCount$set;
        private long signingCount$value;
        private Instant createdAt;
        private Instant lastUsedAt;
        private String description;

        BunkerKeyBuilder() {
        }

        public BunkerKeyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BunkerKeyBuilder npub(String npub) {
            this.npub = npub;
            return this;
        }

        @JsonProperty(value="pubkey")
        public BunkerKeyBuilder pubkeyHex(String pubkeyHex) {
            this.pubkeyHex = pubkeyHex;
            return this;
        }

        public BunkerKeyBuilder locked(boolean locked) {
            this.locked$value = locked;
            this.locked$set = true;
            return this;
        }

        @JsonProperty(value="user_count")
        public BunkerKeyBuilder userCount(int userCount) {
            this.userCount$value = userCount;
            this.userCount$set = true;
            return this;
        }

        @JsonProperty(value="token_count")
        public BunkerKeyBuilder tokenCount(int tokenCount) {
            this.tokenCount$value = tokenCount;
            this.tokenCount$set = true;
            return this;
        }

        @JsonProperty(value="signing_count")
        public BunkerKeyBuilder signingCount(long signingCount) {
            this.signingCount$value = signingCount;
            this.signingCount$set = true;
            return this;
        }

        @JsonProperty(value="created_at")
        public BunkerKeyBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="last_used_at")
        public BunkerKeyBuilder lastUsedAt(Instant lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        public BunkerKeyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BunkerKey build() {
            boolean locked$value = this.locked$value;
            if (!this.locked$set) {
                locked$value = BunkerKey.$default$locked();
            }
            int userCount$value = this.userCount$value;
            if (!this.userCount$set) {
                userCount$value = BunkerKey.$default$userCount();
            }
            int tokenCount$value = this.tokenCount$value;
            if (!this.tokenCount$set) {
                tokenCount$value = BunkerKey.$default$tokenCount();
            }
            long signingCount$value = this.signingCount$value;
            if (!this.signingCount$set) {
                signingCount$value = BunkerKey.$default$signingCount();
            }
            return new BunkerKey(this.name, this.npub, this.pubkeyHex, locked$value, userCount$value, tokenCount$value, signingCount$value, this.createdAt, this.lastUsedAt, this.description);
        }

        public String toString() {
            return "BunkerKey.BunkerKeyBuilder(name=" + this.name + ", npub=" + this.npub + ", pubkeyHex=" + this.pubkeyHex + ", locked$value=" + this.locked$value + ", userCount$value=" + this.userCount$value + ", tokenCount$value=" + this.tokenCount$value + ", signingCount$value=" + this.signingCount$value + ", createdAt=" + String.valueOf(this.createdAt) + ", lastUsedAt=" + String.valueOf(this.lastUsedAt) + ", description=" + this.description + ")";
        }
    }
}

