/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SigningConditionBuilder.class)
public final class SigningCondition {
    private final ConditionType type;
    private final String method;
    @JsonProperty(value="event_kind")
    private final Integer eventKind;
    @JsonProperty(value="valid_from")
    private final Instant validFrom;
    @JsonProperty(value="valid_until")
    private final Instant validUntil;
    @JsonProperty(value="max_operations")
    private final Integer maxOperations;
    @JsonProperty(value="rate_limit_window_seconds")
    private final Integer rateLimitWindowSeconds;
    @JsonProperty(value="allowed_recipient")
    private final String allowedRecipient;
    @JsonProperty(value="content_pattern")
    private final String contentPattern;
    @JsonProperty(value="is_allow")
    private final boolean allow;
    private final String description;

    public static SigningCondition allowEventKind(int eventKind) {
        return SigningCondition.builder().type(ConditionType.EVENT_KIND).eventKind(eventKind).allow(true).build();
    }

    public static SigningCondition allowMethod(String method) {
        return SigningCondition.builder().type(ConditionType.METHOD).method(method).allow(true).build();
    }

    public static SigningCondition timeWindow(Instant from, Instant until) {
        return SigningCondition.builder().type(ConditionType.TIME_WINDOW).validFrom(from).validUntil(until).allow(true).build();
    }

    public static SigningCondition rateLimit(int maxOperations, int windowSeconds) {
        return SigningCondition.builder().type(ConditionType.RATE_LIMIT).maxOperations(maxOperations).rateLimitWindowSeconds(windowSeconds).allow(true).build();
    }

    public boolean isWithinTimeWindow() {
        Instant now = Instant.now();
        if (this.validFrom != null && now.isBefore(this.validFrom)) {
            return false;
        }
        return this.validUntil == null || !now.isAfter(this.validUntil);
    }

    public boolean appliesTo(int kind) {
        return this.eventKind == null || this.eventKind == kind;
    }

    public boolean appliesTo(String targetMethod) {
        return this.method == null || this.method.equals(targetMethod);
    }

    public boolean matchesContentPattern(String content) {
        if (this.contentPattern == null || this.contentPattern.isEmpty()) {
            return true;
        }
        return content != null && content.matches(this.contentPattern);
    }

    public boolean isAllowCondition() {
        return this.allow;
    }

    public boolean isDenyCondition() {
        return !this.allow;
    }

    private static boolean $default$allow() {
        return true;
    }

    SigningCondition(ConditionType type, String method, Integer eventKind, Instant validFrom, Instant validUntil, Integer maxOperations, Integer rateLimitWindowSeconds, String allowedRecipient, String contentPattern, boolean allow, String description) {
        this.type = type;
        this.method = method;
        this.eventKind = eventKind;
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        this.maxOperations = maxOperations;
        this.rateLimitWindowSeconds = rateLimitWindowSeconds;
        this.allowedRecipient = allowedRecipient;
        this.contentPattern = contentPattern;
        this.allow = allow;
        this.description = description;
    }

    public static SigningConditionBuilder builder() {
        return new SigningConditionBuilder();
    }

    public SigningConditionBuilder toBuilder() {
        return new SigningConditionBuilder().type(this.type).method(this.method).eventKind(this.eventKind).validFrom(this.validFrom).validUntil(this.validUntil).maxOperations(this.maxOperations).rateLimitWindowSeconds(this.rateLimitWindowSeconds).allowedRecipient(this.allowedRecipient).contentPattern(this.contentPattern).allow(this.allow).description(this.description);
    }

    public ConditionType getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    public Integer getEventKind() {
        return this.eventKind;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Instant getValidUntil() {
        return this.validUntil;
    }

    public Integer getMaxOperations() {
        return this.maxOperations;
    }

    public Integer getRateLimitWindowSeconds() {
        return this.rateLimitWindowSeconds;
    }

    public String getAllowedRecipient() {
        return this.allowedRecipient;
    }

    public String getContentPattern() {
        return this.contentPattern;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigningCondition)) {
            return false;
        }
        SigningCondition other = (SigningCondition)o;
        if (this.isAllow() != other.isAllow()) {
            return false;
        }
        Integer this$eventKind = this.getEventKind();
        Integer other$eventKind = other.getEventKind();
        if (this$eventKind == null ? other$eventKind != null : !((Object)this$eventKind).equals(other$eventKind)) {
            return false;
        }
        Integer this$maxOperations = this.getMaxOperations();
        Integer other$maxOperations = other.getMaxOperations();
        if (this$maxOperations == null ? other$maxOperations != null : !((Object)this$maxOperations).equals(other$maxOperations)) {
            return false;
        }
        Integer this$rateLimitWindowSeconds = this.getRateLimitWindowSeconds();
        Integer other$rateLimitWindowSeconds = other.getRateLimitWindowSeconds();
        if (this$rateLimitWindowSeconds == null ? other$rateLimitWindowSeconds != null : !((Object)this$rateLimitWindowSeconds).equals(other$rateLimitWindowSeconds)) {
            return false;
        }
        ConditionType this$type = this.getType();
        ConditionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Instant this$validFrom = this.getValidFrom();
        Instant other$validFrom = other.getValidFrom();
        if (this$validFrom == null ? other$validFrom != null : !((Object)this$validFrom).equals(other$validFrom)) {
            return false;
        }
        Instant this$validUntil = this.getValidUntil();
        Instant other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        String this$allowedRecipient = this.getAllowedRecipient();
        String other$allowedRecipient = other.getAllowedRecipient();
        if (this$allowedRecipient == null ? other$allowedRecipient != null : !this$allowedRecipient.equals(other$allowedRecipient)) {
            return false;
        }
        String this$contentPattern = this.getContentPattern();
        String other$contentPattern = other.getContentPattern();
        if (this$contentPattern == null ? other$contentPattern != null : !this$contentPattern.equals(other$contentPattern)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllow() ? 79 : 97);
        Integer $eventKind = this.getEventKind();
        result = result * 59 + ($eventKind == null ? 43 : ((Object)$eventKind).hashCode());
        Integer $maxOperations = this.getMaxOperations();
        result = result * 59 + ($maxOperations == null ? 43 : ((Object)$maxOperations).hashCode());
        Integer $rateLimitWindowSeconds = this.getRateLimitWindowSeconds();
        result = result * 59 + ($rateLimitWindowSeconds == null ? 43 : ((Object)$rateLimitWindowSeconds).hashCode());
        ConditionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Instant $validFrom = this.getValidFrom();
        result = result * 59 + ($validFrom == null ? 43 : ((Object)$validFrom).hashCode());
        Instant $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        String $allowedRecipient = this.getAllowedRecipient();
        result = result * 59 + ($allowedRecipient == null ? 43 : $allowedRecipient.hashCode());
        String $contentPattern = this.getContentPattern();
        result = result * 59 + ($contentPattern == null ? 43 : $contentPattern.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "SigningCondition(type=" + String.valueOf((Object)this.getType()) + ", method=" + this.getMethod() + ", eventKind=" + this.getEventKind() + ", validFrom=" + String.valueOf(this.getValidFrom()) + ", validUntil=" + String.valueOf(this.getValidUntil()) + ", maxOperations=" + this.getMaxOperations() + ", rateLimitWindowSeconds=" + this.getRateLimitWindowSeconds() + ", allowedRecipient=" + this.getAllowedRecipient() + ", contentPattern=" + this.getContentPattern() + ", allow=" + this.isAllow() + ", description=" + this.getDescription() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SigningConditionBuilder {
        private ConditionType type;
        private String method;
        private Integer eventKind;
        private Instant validFrom;
        private Instant validUntil;
        private Integer maxOperations;
        private Integer rateLimitWindowSeconds;
        private String allowedRecipient;
        private String contentPattern;
        private boolean allow$set;
        private boolean allow$value;
        private String description;

        SigningConditionBuilder() {
        }

        public SigningConditionBuilder type(ConditionType type) {
            this.type = type;
            return this;
        }

        public SigningConditionBuilder method(String method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="event_kind")
        public SigningConditionBuilder eventKind(Integer eventKind) {
            this.eventKind = eventKind;
            return this;
        }

        @JsonProperty(value="valid_from")
        public SigningConditionBuilder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @JsonProperty(value="valid_until")
        public SigningConditionBuilder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @JsonProperty(value="max_operations")
        public SigningConditionBuilder maxOperations(Integer maxOperations) {
            this.maxOperations = maxOperations;
            return this;
        }

        @JsonProperty(value="rate_limit_window_seconds")
        public SigningConditionBuilder rateLimitWindowSeconds(Integer rateLimitWindowSeconds) {
            this.rateLimitWindowSeconds = rateLimitWindowSeconds;
            return this;
        }

        @JsonProperty(value="allowed_recipient")
        public SigningConditionBuilder allowedRecipient(String allowedRecipient) {
            this.allowedRecipient = allowedRecipient;
            return this;
        }

        @JsonProperty(value="content_pattern")
        public SigningConditionBuilder contentPattern(String contentPattern) {
            this.contentPattern = contentPattern;
            return this;
        }

        @JsonProperty(value="is_allow")
        public SigningConditionBuilder allow(boolean allow) {
            this.allow$value = allow;
            this.allow$set = true;
            return this;
        }

        public SigningConditionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SigningCondition build() {
            boolean allow$value = this.allow$value;
            if (!this.allow$set) {
                allow$value = SigningCondition.$default$allow();
            }
            return new SigningCondition(this.type, this.method, this.eventKind, this.validFrom, this.validUntil, this.maxOperations, this.rateLimitWindowSeconds, this.allowedRecipient, this.contentPattern, allow$value, this.description);
        }

        public String toString() {
            return "SigningCondition.SigningConditionBuilder(type=" + String.valueOf((Object)this.type) + ", method=" + this.method + ", eventKind=" + this.eventKind + ", validFrom=" + String.valueOf(this.validFrom) + ", validUntil=" + String.valueOf(this.validUntil) + ", maxOperations=" + this.maxOperations + ", rateLimitWindowSeconds=" + this.rateLimitWindowSeconds + ", allowedRecipient=" + this.allowedRecipient + ", contentPattern=" + this.contentPattern + ", allow$value=" + this.allow$value + ", description=" + this.description + ")";
        }
    }

    public static enum ConditionType {
        EVENT_KIND,
        METHOD,
        TIME_WINDOW,
        RATE_LIMIT,
        RECIPIENT,
        CONTENT_PATTERN,
        CUSTOM;

    }
}

