/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.crypto;

import java.util.Objects;
import nostr.encryption.MessageCipher04;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nip04Crypto {
    private static final Logger log = LoggerFactory.getLogger(Nip04Crypto.class);
    private final MessageCipher04 cipher;
    private final byte[] senderPrivateKey;
    private final byte[] recipientPublicKey;

    private Nip04Crypto(byte[] senderPrivateKey, byte[] recipientPublicKey) {
        this.senderPrivateKey = (byte[])senderPrivateKey.clone();
        this.recipientPublicKey = (byte[])recipientPublicKey.clone();
        this.cipher = new MessageCipher04(senderPrivateKey, recipientPublicKey);
    }

    public static Nip04Crypto create(String senderPrivateKeyHex, String recipientPublicKeyHex) {
        Objects.requireNonNull(senderPrivateKeyHex, "Sender private key must not be null");
        Objects.requireNonNull(recipientPublicKeyHex, "Recipient public key must not be null");
        byte[] privateKey = Nip04Crypto.hexToBytes(senderPrivateKeyHex);
        byte[] publicKey = Nip04Crypto.hexToBytes(recipientPublicKeyHex);
        Nip04Crypto.validateKeyLength(privateKey, "private key");
        Nip04Crypto.validateKeyLength(publicKey, "public key");
        return new Nip04Crypto(privateKey, publicKey);
    }

    public static Nip04Crypto create(byte[] senderPrivateKey, byte[] recipientPublicKey) {
        Objects.requireNonNull(senderPrivateKey, "Sender private key must not be null");
        Objects.requireNonNull(recipientPublicKey, "Recipient public key must not be null");
        Nip04Crypto.validateKeyLength(senderPrivateKey, "private key");
        Nip04Crypto.validateKeyLength(recipientPublicKey, "public key");
        return new Nip04Crypto(senderPrivateKey, recipientPublicKey);
    }

    public String encrypt(String plaintext) {
        Objects.requireNonNull(plaintext, "Plaintext must not be null");
        try {
            log.debug("Encrypting message of length {}", (Object)plaintext.length());
            return this.cipher.encrypt(plaintext);
        }
        catch (Exception e) {
            throw new Nip04CryptoException("Failed to encrypt message", e);
        }
    }

    public String decrypt(String ciphertext) {
        Objects.requireNonNull(ciphertext, "Ciphertext must not be null");
        if (!ciphertext.contains("?iv=")) {
            throw new Nip04CryptoException("Invalid NIP-04 format: missing IV separator");
        }
        try {
            log.debug("Decrypting message of length {}", (Object)ciphertext.length());
            return this.cipher.decrypt(ciphertext);
        }
        catch (Exception e) {
            throw new Nip04CryptoException("Failed to decrypt message", e);
        }
    }

    public byte[] getSenderPrivateKey() {
        return (byte[])this.senderPrivateKey.clone();
    }

    public byte[] getRecipientPublicKey() {
        return (byte[])this.recipientPublicKey.clone();
    }

    public String getSenderPrivateKeyHex() {
        return Nip04Crypto.bytesToHex(this.senderPrivateKey);
    }

    public String getRecipientPublicKeyHex() {
        return Nip04Crypto.bytesToHex(this.recipientPublicKey);
    }

    private static void validateKeyLength(byte[] key, String keyType) {
        if (key.length != 32) {
            throw new IllegalArgumentException(String.format("Invalid %s length: expected 32 bytes, got %d", keyType, key.length));
        }
    }

    private static byte[] hexToBytes(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex string must have even length");
        }
        byte[] bytes = new byte[hex.length() / 2];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int index = i2 * 2;
            int value = Integer.parseInt(hex.substring(index, index + 2), 16);
            bytes[i2] = (byte)value;
        }
        return bytes;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }

    public static class Nip04CryptoException
    extends RuntimeException {
        public Nip04CryptoException(String message) {
            super(message);
        }

        public Nip04CryptoException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

