/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Method;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Nip46RequestBuilder.class)
public class Nip46Request {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="method")
    private final String method;
    @JsonProperty(value="params")
    private final List<Object> params;

    @JsonIgnore
    public Nip46Method getMethodEnum() {
        return Nip46Method.tryFromValue(this.method);
    }

    @JsonIgnore
    public boolean hasKnownMethod() {
        return this.getMethodEnum() != null;
    }

    @JsonIgnore
    public String getFirstParam() {
        return this.params != null && !this.params.isEmpty() ? String.valueOf(this.params.get(0)) : null;
    }

    @JsonIgnore
    public String getSecondParam() {
        return this.params != null && this.params.size() > 1 ? String.valueOf(this.params.get(1)) : null;
    }

    public static Nip46Request connect(String pubkey) {
        return Nip46Request.connect(pubkey, null);
    }

    public static Nip46Request connect(String pubkey, String secret) {
        Objects.requireNonNull(pubkey, "pubkey must not be null");
        List<Object> params = secret != null ? Arrays.asList(pubkey, secret) : Collections.singletonList(pubkey);
        return Nip46Request.builder().method(Nip46Method.CONNECT.getValue()).params(params).build();
    }

    public static Nip46Request getPublicKey() {
        return Nip46Request.builder().method(Nip46Method.GET_PUBLIC_KEY.getValue()).build();
    }

    public static Nip46Request signEvent(String eventJson) {
        Objects.requireNonNull(eventJson, "eventJson must not be null");
        return Nip46Request.builder().method(Nip46Method.SIGN_EVENT.getValue()).params(Collections.singletonList(eventJson)).build();
    }

    public static Nip46Request nip04Encrypt(String thirdPartyPubkey, String plaintext) {
        Objects.requireNonNull(thirdPartyPubkey, "thirdPartyPubkey must not be null");
        Objects.requireNonNull(plaintext, "plaintext must not be null");
        return Nip46Request.builder().method(Nip46Method.NIP04_ENCRYPT.getValue()).params(Arrays.asList(thirdPartyPubkey, plaintext)).build();
    }

    public static Nip46Request nip04Decrypt(String thirdPartyPubkey, String ciphertext) {
        Objects.requireNonNull(thirdPartyPubkey, "thirdPartyPubkey must not be null");
        Objects.requireNonNull(ciphertext, "ciphertext must not be null");
        return Nip46Request.builder().method(Nip46Method.NIP04_DECRYPT.getValue()).params(Arrays.asList(thirdPartyPubkey, ciphertext)).build();
    }

    public static Nip46Request nip44Encrypt(String thirdPartyPubkey, String plaintext) {
        Objects.requireNonNull(thirdPartyPubkey, "thirdPartyPubkey must not be null");
        Objects.requireNonNull(plaintext, "plaintext must not be null");
        return Nip46Request.builder().method(Nip46Method.NIP44_ENCRYPT.getValue()).params(Arrays.asList(thirdPartyPubkey, plaintext)).build();
    }

    public static Nip46Request nip44Decrypt(String thirdPartyPubkey, String ciphertext) {
        Objects.requireNonNull(thirdPartyPubkey, "thirdPartyPubkey must not be null");
        Objects.requireNonNull(ciphertext, "ciphertext must not be null");
        return Nip46Request.builder().method(Nip46Method.NIP44_DECRYPT.getValue()).params(Arrays.asList(thirdPartyPubkey, ciphertext)).build();
    }

    public static Nip46Request ping() {
        return Nip46Request.builder().method(Nip46Method.PING.getValue()).build();
    }

    public static Nip46Request getRelays() {
        return Nip46Request.builder().method(Nip46Method.GET_RELAYS.getValue()).build();
    }

    public String toString() {
        return "Nip46Request{id='" + this.id + "', method='" + this.method + "', params=" + String.valueOf(this.params) + "}";
    }

    private static String $default$id() {
        return UUID.randomUUID().toString();
    }

    private static List<Object> $default$params() {
        return Collections.emptyList();
    }

    Nip46Request(String id, String method, List<Object> params) {
        this.id = id;
        this.method = method;
        this.params = params;
    }

    public static Nip46RequestBuilder builder() {
        return new Nip46RequestBuilder();
    }

    public Nip46RequestBuilder toBuilder() {
        return new Nip46RequestBuilder().id(this.id).method(this.method).params(this.params);
    }

    public String getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nip46Request)) {
            return false;
        }
        Nip46Request other = (Nip46Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List<Object> this$params = this.getParams();
        List<Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nip46Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List<Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Nip46RequestBuilder {
        private boolean id$set;
        private String id$value;
        private String method;
        private boolean params$set;
        private List<Object> params$value;

        Nip46RequestBuilder() {
        }

        @JsonProperty(value="id")
        public Nip46RequestBuilder id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @JsonProperty(value="method")
        public Nip46RequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="params")
        public Nip46RequestBuilder params(List<Object> params) {
            this.params$value = params;
            this.params$set = true;
            return this;
        }

        public Nip46Request build() {
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = Nip46Request.$default$id();
            }
            List<Object> params$value = this.params$value;
            if (!this.params$set) {
                params$value = Nip46Request.$default$params();
            }
            return new Nip46Request(id$value, this.method, params$value);
        }

        public String toString() {
            return "Nip46Request.Nip46RequestBuilder(id$value=" + this.id$value + ", method=" + this.method + ", params$value=" + String.valueOf(this.params$value) + ")";
        }
    }
}

