/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public class PendingRequest {
    private static final Logger log = LoggerFactory.getLogger(PendingRequest.class);
    private final Nip46Request request;
    private final CompletableFuture<Nip46Response> future;
    private final Instant createdAt;
    private final Duration timeout;
    private volatile ScheduledFuture<?> timeoutFuture;
    private volatile Instant completedAt;
    private volatile boolean timedOut;

    public PendingRequest(Nip46Request request, Duration timeout2) {
        this.request = Objects.requireNonNull(request, "Request must not be null");
        this.timeout = Objects.requireNonNull(timeout2, "Timeout must not be null");
        this.future = new CompletableFuture();
        this.createdAt = Instant.now();
    }

    public PendingRequest(Nip46Request request) {
        this(request, Duration.ofSeconds(30L));
    }

    public String getId() {
        return this.request.getId();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public boolean isPending() {
        return !this.future.isDone();
    }

    public boolean isCompleted() {
        return this.future.isDone() && !this.timedOut && !this.future.isCompletedExceptionally();
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean isFailed() {
        return this.future.isCompletedExceptionally();
    }

    public boolean complete(Nip46Response response) {
        Objects.requireNonNull(response, "Response must not be null");
        if (this.future.complete(response)) {
            this.completedAt = Instant.now();
            this.cancelTimeoutTask();
            log.debug("Request {} completed with response", (Object)this.getId());
            return true;
        }
        return false;
    }

    public boolean completeExceptionally(Throwable exception) {
        Objects.requireNonNull(exception, "Exception must not be null");
        if (this.future.completeExceptionally(exception)) {
            this.completedAt = Instant.now();
            this.cancelTimeoutTask();
            log.debug("Request {} completed exceptionally: {}", (Object)this.getId(), (Object)exception.getMessage());
            return true;
        }
        return false;
    }

    public boolean timeout() {
        TimeoutException exception = new TimeoutException(String.format("Request %s timed out after %s", this.getId(), this.timeout));
        if (this.future.completeExceptionally(exception)) {
            this.timedOut = true;
            this.completedAt = Instant.now();
            log.debug("Request {} timed out", (Object)this.getId());
            return true;
        }
        return false;
    }

    public boolean cancel() {
        if (this.future.cancel(false)) {
            this.completedAt = Instant.now();
            this.cancelTimeoutTask();
            log.debug("Request {} cancelled", (Object)this.getId());
            return true;
        }
        return false;
    }

    public Duration getElapsed() {
        Instant end = this.completedAt != null ? this.completedAt : Instant.now();
        return Duration.between(this.createdAt, end);
    }

    public Duration getRemaining() {
        if (this.timedOut || this.future.isDone()) {
            return Duration.ZERO;
        }
        Duration elapsed = this.getElapsed();
        Duration remaining = this.timeout.minus(elapsed);
        return remaining.isNegative() ? Duration.ZERO : remaining;
    }

    void setTimeoutFuture(ScheduledFuture<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
    }

    private void cancelTimeoutTask() {
        if (this.timeoutFuture != null && !this.timeoutFuture.isDone()) {
            this.timeoutFuture.cancel(false);
        }
    }

    public String toString() {
        return String.format("PendingRequest[id=%s, method=%s, pending=%s, elapsed=%s]", this.getId(), this.getMethod(), this.isPending(), this.getElapsed());
    }

    public Nip46Request getRequest() {
        return this.request;
    }

    public CompletableFuture<Nip46Response> getFuture() {
        return this.future;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public ScheduledFuture<?> getTimeoutFuture() {
        return this.timeoutFuture;
    }

    public Instant getCompletedAt() {
        return this.completedAt;
    }
}

