/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;
import xyz.tcheeric.nsecbunker.protocol.nip46.PendingRequest;

public class PendingRequestManager {
    private static final Logger log = LoggerFactory.getLogger(PendingRequestManager.class);
    private final Map<String, PendingRequest> pendingRequests;
    private final ScheduledExecutorService scheduler;
    private final boolean ownsScheduler;
    private final Duration defaultTimeout;

    public PendingRequestManager() {
        this(Duration.ofSeconds(30L));
    }

    public PendingRequestManager(Duration defaultTimeout) {
        this(defaultTimeout, Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "nip46-timeout-scheduler");
            t.setDaemon(true);
            return t;
        }), true);
    }

    public PendingRequestManager(Duration defaultTimeout, ScheduledExecutorService scheduler) {
        this(defaultTimeout, scheduler, false);
    }

    private PendingRequestManager(Duration defaultTimeout, ScheduledExecutorService scheduler, boolean ownsScheduler) {
        this.defaultTimeout = Objects.requireNonNull(defaultTimeout, "Default timeout must not be null");
        this.scheduler = Objects.requireNonNull(scheduler, "Scheduler must not be null");
        this.ownsScheduler = ownsScheduler;
        this.pendingRequests = new ConcurrentHashMap<String, PendingRequest>();
    }

    public CompletableFuture<Nip46Response> register(Nip46Request request) {
        return this.register(request, this.defaultTimeout);
    }

    public CompletableFuture<Nip46Response> register(Nip46Request request, Duration timeout2) {
        Objects.requireNonNull(request, "Request must not be null");
        Objects.requireNonNull(timeout2, "Timeout must not be null");
        String id = request.getId();
        PendingRequest pending = new PendingRequest(request, timeout2);
        PendingRequest existing = this.pendingRequests.putIfAbsent(id, pending);
        if (existing != null) {
            throw new IllegalArgumentException("Request with ID already pending: " + id);
        }
        ScheduledFuture<?> timeoutFuture = this.scheduler.schedule(() -> this.timeoutRequest(id), timeout2.toMillis(), TimeUnit.MILLISECONDS);
        pending.setTimeoutFuture(timeoutFuture);
        pending.getFuture().whenComplete((response, ex) -> this.pendingRequests.remove(id));
        log.debug("Registered pending request: {}", (Object)id);
        return pending.getFuture();
    }

    public boolean complete(Nip46Response response) {
        Objects.requireNonNull(response, "Response must not be null");
        String id = response.getId();
        PendingRequest pending = this.pendingRequests.get(id);
        if (pending == null) {
            log.debug("No pending request found for response ID: {}", (Object)id);
            return false;
        }
        return pending.complete(response);
    }

    public boolean completeExceptionally(String requestId, Throwable exception) {
        Objects.requireNonNull(requestId, "Request ID must not be null");
        Objects.requireNonNull(exception, "Exception must not be null");
        PendingRequest pending = this.pendingRequests.get(requestId);
        if (pending == null) {
            log.debug("No pending request found for ID: {}", (Object)requestId);
            return false;
        }
        return pending.completeExceptionally(exception);
    }

    public boolean cancel(String requestId) {
        Objects.requireNonNull(requestId, "Request ID must not be null");
        PendingRequest pending = this.pendingRequests.get(requestId);
        if (pending == null) {
            return false;
        }
        return pending.cancel();
    }

    public int cancelAll() {
        int count = 0;
        for (PendingRequest pending : this.pendingRequests.values()) {
            if (!pending.cancel()) continue;
            ++count;
        }
        log.debug("Cancelled {} pending requests", (Object)count);
        return count;
    }

    public Optional<PendingRequest> get(String requestId) {
        return Optional.ofNullable(this.pendingRequests.get(requestId));
    }

    public boolean isPending(String requestId) {
        PendingRequest pending = this.pendingRequests.get(requestId);
        return pending != null && pending.isPending();
    }

    public Collection<PendingRequest> getPendingRequests() {
        return this.pendingRequests.values().stream().filter(PendingRequest::isPending).toList();
    }

    public int getPendingCount() {
        return (int)this.pendingRequests.values().stream().filter(PendingRequest::isPending).count();
    }

    public void clearCompleted() {
        this.pendingRequests.entrySet().removeIf(entry -> !((PendingRequest)entry.getValue()).isPending());
    }

    public void shutdown() {
        this.cancelAll();
        if (this.ownsScheduler) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        log.debug("PendingRequestManager shut down");
    }

    private void timeoutRequest(String requestId) {
        PendingRequest pending = this.pendingRequests.get(requestId);
        if (pending != null) {
            pending.timeout();
        }
    }

    public Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }
}

