/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.storage.file;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;

public class IdentityMetadataStore {
    private static final String DEFAULT_BASE_DIR = System.getProperty("user.home") + "/.cashu/identities";
    private static final String METADATA_FILENAME = "identities.json";
    private final Path metadataFile;
    private final ObjectMapper objectMapper;
    private final Object lock = new Object();

    public IdentityMetadataStore() throws IdentityStorageException {
        this(Paths.get(DEFAULT_BASE_DIR, new String[0]));
    }

    public IdentityMetadataStore(Path baseDirectory) throws IdentityStorageException {
        this.metadataFile = baseDirectory.resolve(METADATA_FILENAME);
        this.objectMapper = this.createObjectMapper();
        this.ensureDirectoryExists(baseDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IdentityMetadata metadata) throws IdentityStorageException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, IdentityMetadata> allMetadata = this.loadAllAsMap();
            allMetadata.put(metadata.getIdentityId(), metadata);
            this.writeMetadata(allMetadata.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityMetadata load(String identityId) throws IdentityStorageException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, IdentityMetadata> allMetadata = this.loadAllAsMap();
            return allMetadata.get(identityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdentityMetadata> listAll() throws IdentityStorageException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, IdentityMetadata> allMetadata = this.loadAllAsMap();
            return allMetadata.values().stream().sorted(Comparator.comparing(IdentityMetadata::getCreatedAt)).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String identityId) throws IdentityStorageException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, IdentityMetadata> allMetadata = this.loadAllAsMap();
            allMetadata.remove(identityId);
            this.writeMetadata(allMetadata.values());
        }
    }

    public boolean exists(String identityId) throws IdentityStorageException {
        return this.load(identityId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefault(String identityId) throws IdentityStorageException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, IdentityMetadata> allMetadata = this.loadAllAsMap();
            if (!allMetadata.containsKey(identityId)) {
                throw new IdentityStorageException("Identity not found: " + identityId);
            }
            HashMap<String, IdentityMetadata> updated = new HashMap<String, IdentityMetadata>();
            for (Map.Entry<String, IdentityMetadata> entry : allMetadata.entrySet()) {
                IdentityMetadata metadata = entry.getValue();
                boolean isDefault = metadata.getIdentityId().equals(identityId);
                updated.put(entry.getKey(), metadata.withDefault(isDefault));
            }
            this.writeMetadata(updated.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityMetadata getDefault() throws IdentityStorageException {
        Object object = this.lock;
        synchronized (object) {
            return this.loadAllAsMap().values().stream().filter(IdentityMetadata::isDefault).findFirst().orElse(null);
        }
    }

    public int count() throws IdentityStorageException {
        return this.listAll().size();
    }

    private Map<String, IdentityMetadata> loadAllAsMap() throws IdentityStorageException {
        if (!Files.exists(this.metadataFile, new LinkOption[0])) {
            return new HashMap<String, IdentityMetadata>();
        }
        try {
            List metadataList = (List)this.objectMapper.readValue(this.metadataFile.toFile(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, IdentityMetadata.class));
            return metadataList.stream().collect(Collectors.toMap(IdentityMetadata::getIdentityId, m -> m));
        }
        catch (IOException e) {
            throw new IdentityStorageException("Failed to load metadata from: " + String.valueOf(this.metadataFile), (Throwable)e);
        }
    }

    private void writeMetadata(Collection<IdentityMetadata> metadata) throws IdentityStorageException {
        try {
            Path tempFile = this.metadataFile.getParent().resolve("identities.json.tmp");
            this.objectMapper.writeValue(tempFile.toFile(), metadata);
            Files.move(tempFile, this.metadataFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new IdentityStorageException("Failed to write metadata to: " + String.valueOf(this.metadataFile), (Throwable)e);
        }
    }

    private void ensureDirectoryExists(Path directory) throws IdentityStorageException {
        try {
            if (!Files.exists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IdentityStorageException("Failed to create directory: " + String.valueOf(directory), (Throwable)e);
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public Path getMetadataFile() {
        return this.metadataFile;
    }
}

