/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.storage.file.encryption;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class KeyDerivation {
    private static final String ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final int ITERATION_COUNT = 100000;
    private static final int DEFAULT_SALT_LENGTH = 16;
    private static final int DEFAULT_KEY_LENGTH = 256;
    private final SecureRandom secureRandom = new SecureRandom();

    public byte[] generateSalt() {
        return this.generateSalt(16);
    }

    public byte[] generateSalt(int length) {
        byte[] salt = new byte[length];
        this.secureRandom.nextBytes(salt);
        return salt;
    }

    public byte[] deriveKey(char[] password, byte[] salt) {
        return this.deriveKey(password, salt, 256);
    }

    public byte[] deriveKey(char[] password, byte[] salt, int keyLengthBits) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, 100000, keyLengthBits);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM);
            byte[] derivedKey = factory.generateSecret(spec).getEncoded();
            this.clearPassword(password);
            return derivedKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Key derivation failed", e);
        }
    }

    public KeyWithSalt deriveKeyWithSalt(char[] password) {
        byte[] salt = this.generateSalt();
        byte[] key = this.deriveKey(password, salt);
        return new KeyWithSalt(key, salt);
    }

    public boolean verifyPassword(char[] password, byte[] salt, byte[] expectedKey) {
        byte[] derivedKey = this.deriveKey(password, salt, expectedKey.length * 8);
        boolean matches = Arrays.equals(derivedKey, expectedKey);
        Arrays.fill(derivedKey, (byte)0);
        return matches;
    }

    public static int getIterationCount() {
        return 100000;
    }

    private void clearPassword(char[] password) {
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
    }

    public static class KeyWithSalt {
        private final byte[] key;
        private final byte[] salt;

        public KeyWithSalt(byte[] key, byte[] salt) {
            this.key = key;
            this.salt = salt;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public void clear() {
            Arrays.fill(this.key, (byte)0);
        }
    }
}

