/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record SignEventResponse(String requestId, boolean success, String errorMessage, String eventId, String signature, String pubkey) implements IdentityMessage
{
    public SignEventResponse {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (success) {
            if (eventId == null || eventId.isBlank()) {
                throw new IllegalArgumentException("eventId must be provided when success is true");
            }
            if (signature == null || signature.isBlank()) {
                throw new IllegalArgumentException("signature must be provided when success is true");
            }
            if (pubkey == null || pubkey.isBlank()) {
                throw new IllegalArgumentException("pubkey must be provided when success is true");
            }
        }
        if (!success && (errorMessage == null || errorMessage.isBlank())) {
            throw new IllegalArgumentException("errorMessage should be provided when success is false");
        }
    }

    public static SignEventResponse success(String requestId, String eventId, String signature, String pubkey) {
        return new SignEventResponse(requestId, true, null, eventId, signature, pubkey);
    }

    public static SignEventResponse failure(String requestId, String errorMessage) {
        return new SignEventResponse(requestId, false, errorMessage, null, null, null);
    }
}

