/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc.JdbcRepositoryException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.ConfigurationSetRepository;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.AutomationContext;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationSet;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

public class JdbcConfigurationSetRepository
implements ConfigurationSetRepository {
    private static final String UPSERT_SQL = "    INSERT INTO configuration_revisions (\n        mint_id,\n        revision_id,\n        parameters,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (mint_id, revision_id) DO UPDATE SET\n        parameters = EXCLUDED.parameters,\n        audit_actor = EXCLUDED.audit_actor,\n        audit_action = EXCLUDED.audit_action,\n        audit_timestamp = EXCLUDED.audit_timestamp,\n        audit_reason_codes = EXCLUDED.audit_reason_codes,\n        audit_ticket_references = EXCLUDED.audit_ticket_references,\n        audit_automation_automated = EXCLUDED.audit_automation_automated,\n        audit_automation_system = EXCLUDED.audit_automation_system,\n        audit_automation_run_id = EXCLUDED.audit_automation_run_id\n";
    private static final String H2_UPSERT_SQL = "    MERGE INTO configuration_revisions (\n        mint_id,\n        revision_id,\n        parameters,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id)\n    KEY (mint_id, revision_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String SELECT_ONE_SQL = "    SELECT\n        revision_id,\n        parameters,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id\n    FROM configuration_revisions\n    WHERE mint_id = ? AND revision_id = ?\n";
    private static final String SELECT_ALL_SQL = "    SELECT\n        revision_id,\n        parameters,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id\n    FROM configuration_revisions\n    WHERE mint_id = ?\n    ORDER BY revision_id\n";
    private static final TypeReference<Map<String, String>> MAP_TYPE = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<List<String>> LIST_TYPE = new TypeReference<List<String>>(){};
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;

    public JdbcConfigurationSetRepository(DataSource dataSource, ObjectMapper objectMapper) {
        this.dataSource = dataSource;
        this.objectMapper = objectMapper;
    }

    @Override
    public void save(MintId mintId, ConfigurationSet configurationSet) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            try {
                this.save(connection, mintId, configurationSet);
                connection.commit();
            }
            catch (IOException | SQLException ex) {
                connection.rollback();
                throw new JdbcRepositoryException("Failed to persist configuration revision", ex);
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            throw new JdbcRepositoryException("Failed to persist configuration revision", ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<ConfigurationSet> findByRevision(MintId mintId, ConfigurationRevisionId revisionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ConfigurationSet> findByMintId(MintId mintId) {
        try (Connection connection = this.dataSource.getConnection();){
            List<ConfigurationSet> list;
            block22: {
                PreparedStatement statement = connection.prepareStatement(SELECT_ALL_SQL);
                try {
                    statement.setObject(1, mintId.value());
                    ArrayList<ConfigurationSet> results = new ArrayList<ConfigurationSet>();
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            results.add(this.mapRow(resultSet));
                        }
                    }
                    list = List.copyOf(results);
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (IOException | SQLException ex) {
            throw new JdbcRepositoryException("Failed to load configuration history", ex);
        }
    }

    void save(Connection connection, MintId mintId, ConfigurationSet configurationSet) throws SQLException, IOException {
        try (PreparedStatement statement = this.prepareUpsertStatement(connection);){
            AuditMetadata audit = configurationSet.auditMetadata();
            statement.setObject(1, mintId.value());
            statement.setLong(2, configurationSet.revisionId().value());
            statement.setString(3, this.objectMapper.writeValueAsString(configurationSet.parameters()));
            statement.setString(4, audit.actor());
            statement.setString(5, audit.action());
            statement.setTimestamp(6, Timestamp.from(audit.timestamp()));
            statement.setString(7, this.writeList(audit.reasonCodes()));
            statement.setString(8, this.writeList(audit.ticketReferences()));
            statement.setBoolean(9, audit.automationContext().automated());
            statement.setString(10, audit.automationContext().system());
            statement.setString(11, audit.automationContext().runId());
            statement.executeUpdate();
        }
    }

    private PreparedStatement prepareUpsertStatement(Connection connection) throws SQLException {
        if (this.isH2(connection)) {
            return connection.prepareStatement(H2_UPSERT_SQL);
        }
        return connection.prepareStatement(UPSERT_SQL);
    }

    private boolean isH2(Connection connection) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        return "H2".equalsIgnoreCase(productName);
    }

    private ConfigurationSet mapRow(ResultSet resultSet) throws SQLException, IOException {
        ConfigurationRevisionId revisionId = ConfigurationRevisionId.of(resultSet.getLong("revision_id"));
        Map<String, String> parameters = this.objectMapper.readValue(resultSet.getString("parameters"), MAP_TYPE);
        AuditMetadata audit = new AuditMetadata(resultSet.getString("audit_actor"), resultSet.getString("audit_action"), this.getInstant(resultSet, "audit_timestamp"), this.readList(resultSet, "audit_reason_codes"), this.readList(resultSet, "audit_ticket_references"), this.mapAutomationContext(resultSet));
        return new ConfigurationSet(revisionId, parameters, audit);
    }

    private String writeList(List<String> values) throws IOException {
        if (values == null || values.isEmpty()) {
            return "[]";
        }
        return this.objectMapper.writeValueAsString(values);
    }

    private List<String> readList(ResultSet resultSet, String column) throws SQLException, IOException {
        String raw = resultSet.getString(column);
        if (raw == null || raw.isBlank()) {
            return List.of();
        }
        return this.objectMapper.readValue(raw, LIST_TYPE);
    }

    private AutomationContext mapAutomationContext(ResultSet resultSet) throws SQLException {
        Boolean automated = (Boolean)resultSet.getObject("audit_automation_automated");
        String system = resultSet.getString("audit_automation_system");
        String runId = resultSet.getString("audit_automation_run_id");
        if (automated == null) {
            return AutomationContext.manual();
        }
        return new AutomationContext(automated, system, runId);
    }

    private Instant getInstant(ResultSet resultSet, String column) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(column);
        if (timestamp == null) {
            return null;
        }
        return timestamp.toInstant();
    }
}

