/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc.JdbcRepositoryException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleEvent;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleHistoryRepository;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.AutomationContext;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleContext;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

public class JdbcMintLifecycleHistoryRepository
implements MintLifecycleHistoryRepository {
    private static final String INSERT_SQL = "    INSERT INTO mint_lifecycle_history (\n        event_id,\n        mint_id,\n        event_type,\n        previous_state,\n        current_state,\n        configuration_revision_id,\n        version_tag,\n        audit_actor,\n        audit_action,\n        audit_timestamp,\n        audit_reason_codes,\n        audit_ticket_references,\n        audit_automation_automated,\n        audit_automation_system,\n        audit_automation_run_id,\n        audit_request_id,\n        audit_correlation_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String SELECT_BY_MINT_SQL = "    SELECT event_id, event_type, previous_state, current_state, configuration_revision_id,\n           version_tag, audit_actor, audit_action, audit_timestamp, audit_reason_codes,\n           audit_ticket_references, audit_automation_automated, audit_automation_system,\n           audit_automation_run_id, audit_request_id, audit_correlation_id\n    FROM mint_lifecycle_history\n    WHERE mint_id = ?\n    ORDER BY audit_timestamp, event_id\n";
    private static final TypeReference<List<String>> LIST_TYPE = new TypeReference<List<String>>(){};
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;

    public JdbcMintLifecycleHistoryRepository(DataSource dataSource, ObjectMapper objectMapper) {
        this.dataSource = dataSource;
        this.objectMapper = objectMapper;
    }

    @Override
    public void append(UUID eventId, MintLifecycleEvent event) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(INSERT_SQL);){
            AuditMetadata audit = event.auditMetadata();
            statement.setObject(1, eventId);
            statement.setObject(2, event.mintId().value());
            statement.setString(3, event.type().name());
            statement.setString(4, this.toState(event.previousState()));
            statement.setString(5, event.currentState().name());
            statement.setLong(6, event.configurationRevisionId().value());
            statement.setString(7, event.versionTag());
            statement.setString(8, audit.actor());
            statement.setString(9, audit.action());
            statement.setTimestamp(10, Timestamp.from(audit.timestamp()));
            statement.setString(11, this.writeList(audit.reasonCodes()));
            statement.setString(12, this.writeList(audit.ticketReferences()));
            statement.setBoolean(13, audit.automationContext().automated());
            statement.setString(14, audit.automationContext().system());
            statement.setString(15, audit.automationContext().runId());
            statement.setObject(16, audit.requestId());
            statement.setString(17, audit.correlationId());
            statement.executeUpdate();
        }
        catch (IOException | SQLException ex) {
            throw new JdbcRepositoryException("Failed to append lifecycle history entry", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<MintLifecycleHistoryRepository.MintLifecycleHistoryEntry> findByMintId(MintId mintId) {
        try (Connection connection = this.dataSource.getConnection();){
            List<MintLifecycleHistoryRepository.MintLifecycleHistoryEntry> list;
            block22: {
                PreparedStatement statement = connection.prepareStatement(SELECT_BY_MINT_SQL);
                try {
                    statement.setObject(1, mintId.value());
                    ArrayList<MintLifecycleHistoryRepository.MintLifecycleHistoryEntry> entries = new ArrayList<MintLifecycleHistoryRepository.MintLifecycleHistoryEntry>();
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            entries.add(this.mapRow(mintId, resultSet));
                        }
                    }
                    list = List.copyOf(entries);
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (IOException | SQLException ex) {
            throw new JdbcRepositoryException("Failed to load lifecycle history", ex);
        }
    }

    private MintLifecycleHistoryRepository.MintLifecycleHistoryEntry mapRow(MintId mintId, ResultSet resultSet) throws SQLException, IOException {
        UUID eventId = this.getUuid(resultSet, "event_id");
        MintLifecycleEvent.MintLifecycleEventType type = MintLifecycleEvent.MintLifecycleEventType.valueOf(resultSet.getString("event_type"));
        LifecycleState.State previous = this.fromNullableState(resultSet.getString("previous_state"));
        LifecycleState.State current = LifecycleState.State.valueOf(resultSet.getString("current_state"));
        ConfigurationRevisionId revision = ConfigurationRevisionId.of(resultSet.getLong("configuration_revision_id"));
        String versionTag = resultSet.getString("version_tag");
        UUID requestId = this.getNullableUuid(resultSet, "audit_request_id");
        String correlationId = resultSet.getString("audit_correlation_id");
        AuditMetadata audit = new AuditMetadata(resultSet.getString("audit_actor"), resultSet.getString("audit_action"), resultSet.getTimestamp("audit_timestamp").toInstant(), this.readList(resultSet, "audit_reason_codes"), this.readList(resultSet, "audit_ticket_references"), new AutomationContext(resultSet.getBoolean("audit_automation_automated"), resultSet.getString("audit_automation_system"), resultSet.getString("audit_automation_run_id")), LifecycleContext.empty(), requestId, correlationId);
        MintLifecycleEvent event = new MintLifecycleEvent(type, mintId, previous, current, revision, versionTag, audit);
        return new MintLifecycleHistoryRepository.MintLifecycleHistoryEntry(eventId, event);
    }

    private String writeList(List<String> values) throws IOException {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return this.objectMapper.writeValueAsString(values);
    }

    private List<String> readList(ResultSet resultSet, String column) throws SQLException, IOException {
        String raw = resultSet.getString(column);
        if (raw == null || raw.isBlank()) {
            return List.of();
        }
        return this.objectMapper.readValue(raw, LIST_TYPE);
    }

    private String toState(LifecycleState.State state) {
        if (state == null) {
            return null;
        }
        return state.name();
    }

    private LifecycleState.State fromNullableState(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        return LifecycleState.State.valueOf(raw);
    }

    private UUID getUuid(ResultSet resultSet, String column) throws SQLException {
        Object raw = resultSet.getObject(column);
        if (raw instanceof UUID) {
            UUID uuid = (UUID)raw;
            return uuid;
        }
        return UUID.fromString(raw.toString());
    }

    private UUID getNullableUuid(ResultSet resultSet, String column) throws SQLException {
        Object raw = resultSet.getObject(column);
        if (raw == null) {
            return null;
        }
        if (raw instanceof UUID) {
            UUID uuid = (UUID)raw;
            return uuid;
        }
        String value = raw.toString();
        if (value.isBlank()) {
            return null;
        }
        return UUID.fromString(value);
    }
}

