/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.outbox;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.cashu.mint.admin.adapter.out.outbox.LifecycleEventOutboxHandler;
import xyz.tcheeric.cashu.mint.admin.adapter.out.outbox.OutboxMessageHandlingException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.OutboxRepository;
import xyz.tcheeric.cashu.mint.admin.domain.OutboxMessage;

public class LifecycleEventOutboxDispatcher {
    private static final Duration OVERFLOW_BACKOFF = Duration.ofHours(24L);
    private final OutboxRepository outboxRepository;
    private final LifecycleEventOutboxHandler handler;
    private final Clock clock;
    private final Duration failureBackoff;

    public LifecycleEventOutboxDispatcher(OutboxRepository outboxRepository, LifecycleEventOutboxHandler handler, Duration failureBackoff) {
        this(outboxRepository, handler, Clock.systemUTC(), failureBackoff);
    }

    public LifecycleEventOutboxDispatcher(OutboxRepository outboxRepository, LifecycleEventOutboxHandler handler, Clock clock, Duration failureBackoff) {
        this.outboxRepository = Objects.requireNonNull(outboxRepository, "outbox repository must not be null");
        this.handler = Objects.requireNonNull(handler, "outbox handler must not be null");
        this.clock = clock == null ? Clock.systemUTC() : clock;
        this.failureBackoff = this.requirePositive(failureBackoff);
    }

    public int dispatchPending(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batch size must be positive");
        }
        Instant now = this.clock.instant();
        List<OutboxMessage> pending = this.outboxRepository.findPending(now, batchSize);
        int processed = 0;
        RuntimeException unexpectedFailure = null;
        for (OutboxMessage message : pending) {
            try {
                this.handler.handle(message);
                this.outboxRepository.markDispatched(message.eventId(), this.clock.instant());
                ++processed;
            }
            catch (OutboxMessageHandlingException ex) {
                this.scheduleRetry(message);
            }
            catch (RuntimeException ex) {
                this.scheduleRetry(message);
                if (unexpectedFailure != null) continue;
                unexpectedFailure = ex;
            }
        }
        if (unexpectedFailure != null) {
            throw unexpectedFailure;
        }
        return processed;
    }

    private void scheduleRetry(OutboxMessage message) {
        Instant attemptAt = this.clock.instant();
        Duration backoff = this.backoffForAttempts(message.deliveryAttempts() + 1);
        Instant retryAt = attemptAt.plus(backoff);
        this.outboxRepository.recordFailure(message.eventId(), attemptAt, retryAt);
    }

    private Duration backoffForAttempts(int attempts) {
        int exponent = Math.max(0, Math.min(5, attempts - 1));
        long multiplier = 1L << exponent;
        try {
            return this.failureBackoff.multipliedBy(multiplier);
        }
        catch (ArithmeticException ex) {
            return OVERFLOW_BACKOFF;
        }
    }

    private Duration requirePositive(Duration value) {
        Duration nonNull = Objects.requireNonNull(value, "failure backoff must not be null");
        if (nonNull.isZero() || nonNull.isNegative()) {
            throw new IllegalArgumentException("failure backoff must be positive");
        }
        return nonNull;
    }
}

