/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.outbox;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import xyz.tcheeric.cashu.mint.admin.adapter.out.outbox.TransactionalOutboxPublishingException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleEvent;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleEventPublisher;
import xyz.tcheeric.cashu.mint.admin.application.port.out.OutboxRepository;
import xyz.tcheeric.cashu.mint.admin.domain.OutboxMessage;

public class TransactionalOutboxMintLifecycleEventPublisher
implements MintLifecycleEventPublisher {
    private static final String AGGREGATE_TYPE = "MintAggregate";
    private static final String EVENT_SCHEMA = "admin.mint-lifecycle.v1";
    private final OutboxRepository outboxRepository;
    private final ObjectMapper objectMapper;

    public TransactionalOutboxMintLifecycleEventPublisher(OutboxRepository outboxRepository, ObjectMapper objectMapper) {
        this.outboxRepository = Objects.requireNonNull(outboxRepository, "outbox repository must not be null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper must not be null");
    }

    @Override
    public void publish(MintLifecycleEvent event) {
        Objects.requireNonNull(event, "mint lifecycle event must not be null");
        UUID eventId = UUID.randomUUID();
        OutboxMessage message = this.toOutboxMessage(eventId, event);
        this.outboxRepository.append(message);
    }

    private OutboxMessage toOutboxMessage(UUID eventId, MintLifecycleEvent event) {
        Instant occurredAt = event.auditMetadata().timestamp();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("schema", EVENT_SCHEMA);
        if (event.versionTag() != null && !event.versionTag().isBlank()) {
            attributes.put("versionTag", event.versionTag());
        }
        String payload = this.writePayload(eventId, event);
        return new OutboxMessage(eventId, event.mintId(), AGGREGATE_TYPE, event.type().name(), payload, Map.copyOf(attributes), occurredAt, occurredAt, null, null, 0);
    }

    private String writePayload(UUID eventId, MintLifecycleEvent event) {
        HashMap<String, Object> automation = new HashMap<String, Object>();
        automation.put("automated", event.auditMetadata().automationContext().automated());
        automation.put("system", event.auditMetadata().automationContext().system());
        automation.put("runId", event.auditMetadata().automationContext().runId());
        HashMap<String, Object> audit = new HashMap<String, Object>();
        audit.put("actor", event.auditMetadata().actor());
        audit.put("action", event.auditMetadata().action());
        audit.put("timestamp", event.auditMetadata().timestamp().toString());
        audit.put("reasonCodes", event.auditMetadata().reasonCodes());
        audit.put("ticketReferences", event.auditMetadata().ticketReferences());
        audit.put("automation", automation);
        audit.put("requestId", event.auditMetadata().requestId() == null ? null : event.auditMetadata().requestId().toString());
        audit.put("correlationId", event.auditMetadata().correlationId());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("eventId", eventId.toString());
        body.put("type", event.type().name());
        body.put("mintId", event.mintId().asString());
        body.put("previousState", event.previousState() == null ? null : event.previousState().name());
        body.put("currentState", event.currentState().name());
        body.put("configurationRevision", event.configurationRevisionId().value());
        body.put("versionTag", event.versionTag());
        body.put("audit", audit);
        try {
            return this.objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException ex) {
            throw new TransactionalOutboxPublishingException("Failed to serialise lifecycle event", ex);
        }
    }
}

