/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.application.service;

import java.util.Objects;
import java.util.UUID;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

abstract class AbstractUseCaseInteractor {
    AbstractUseCaseInteractor() {
    }

    protected <T> T requireRequest(T request, String name) {
        return Objects.requireNonNull(request, name + " must not be null");
    }

    protected MintId validateMintId(String rawMintId) {
        return MintId.fromString(rawMintId);
    }

    protected UUID validateUuid(String rawIdentifier, String fieldName) {
        if (rawIdentifier == null || rawIdentifier.isBlank()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        try {
            return UUID.fromString(rawIdentifier);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(fieldName + " must be a valid UUID", ex);
        }
    }

    protected ConfigurationRevisionId validateConfigurationRevision(String rawRevision) {
        if (rawRevision == null || rawRevision.isBlank()) {
            throw new IllegalArgumentException("configuration revision must not be blank");
        }
        try {
            long numericRevision = Long.parseLong(rawRevision);
            return ConfigurationRevisionId.of(numericRevision);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("configuration revision must be a positive integer", ex);
        }
    }

    protected String validateVersionTag(String versionTag) {
        if (versionTag == null || versionTag.isBlank()) {
            throw new IllegalArgumentException("version tag must not be blank");
        }
        return versionTag;
    }
}

