/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.command;

import java.util.Objects;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.command.CommandIOOptions;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingService;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintConfigRequest;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintConfigResponse;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintConfigPort;

@CommandLine.Command(name="config", description={"Inspect or apply mint configuration"}, mixinStandardHelpOptions=true)
public final class MintConfigCommand
implements Callable<Integer> {
    private final MintConfigPort configPort;
    private final CommandPayloadMapper payloadMapper;
    private final ResponseRenderingService renderingService;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-m", "--mint-id"}, description={"Mint identifier to target when no payload is provided."}, defaultValue="default-mint")
    private String mintId = "default-mint";
    @CommandLine.Mixin
    private final CommandIOOptions ioOptions = new CommandIOOptions();

    public MintConfigCommand(MintConfigPort configPort, CommandPayloadMapper payloadMapper, ResponseRenderingService renderingService) {
        this.configPort = Objects.requireNonNull(configPort, "configPort");
        this.payloadMapper = Objects.requireNonNull(payloadMapper, "payloadMapper");
        this.renderingService = Objects.requireNonNull(renderingService, "renderingService");
    }

    @Override
    public Integer call() {
        MintConfigRequest request = this.ioOptions.readPayload(this.payloadMapper, MintConfigRequest.class).orElseGet(() -> MintConfigRequest.withDefaults(this.mintId));
        MintConfigResponse response = this.configPort.applyConfiguration(request);
        this.spec.commandLine().getOut().println(this.renderingService.render(response, this.ioOptions.outputFormat()));
        return 0;
    }
}

